# codegen-api-client
API for application developers

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.12.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage

### uv sync

If the python package is hosted on a repository, you can install directly using:

```sh
uv pip install codegen-api-client
```

Then import the package:
```python
import codegen_api_client
```


### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import codegen_api_client
from codegen_api_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = codegen_api_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with codegen_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = codegen_api_client.AgentsApi(api_client)
    org_id = 56 # int | 
    create_agent_run_input = codegen_api_client.CreateAgentRunInput() # CreateAgentRunInput | 
    authorization = None # object |  (optional)

    try:
        # Create Agent Run
        api_response = api_instance.create_agent_run_v1_organizations_org_id_agent_run_post(org_id, create_agent_run_input, authorization=authorization)
        print("The response of AgentsApi->create_agent_run_v1_organizations_org_id_agent_run_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AgentsApi->create_agent_run_v1_organizations_org_id_agent_run_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AgentsApi* | [**create_agent_run_v1_organizations_org_id_agent_run_post**](docs/AgentsApi.md#create_agent_run_v1_organizations_org_id_agent_run_post) | **POST** /v1/organizations/{org_id}/agent/run | Create Agent Run
*AgentsApi* | [**create_agent_run_v1_organizations_org_id_agent_run_post_0**](docs/AgentsApi.md#create_agent_run_v1_organizations_org_id_agent_run_post_0) | **POST** /v1/organizations/{org_id}/agent/run | Create Agent Run
*AgentsApi* | [**create_agent_run_v1_organizations_org_id_agent_run_post_1**](docs/AgentsApi.md#create_agent_run_v1_organizations_org_id_agent_run_post_1) | **POST** /v1/organizations/{org_id}/agent/run | Create Agent Run
*AgentsApi* | [**get_agent_run_v1_organizations_org_id_agent_run_agent_run_id_get**](docs/AgentsApi.md#get_agent_run_v1_organizations_org_id_agent_run_agent_run_id_get) | **GET** /v1/organizations/{org_id}/agent/run/{agent_run_id} | Get Agent Run
*AgentsApi* | [**get_agent_run_v1_organizations_org_id_agent_run_agent_run_id_get_0**](docs/AgentsApi.md#get_agent_run_v1_organizations_org_id_agent_run_agent_run_id_get_0) | **GET** /v1/organizations/{org_id}/agent/run/{agent_run_id} | Get Agent Run
*AgentsApi* | [**get_agent_run_v1_organizations_org_id_agent_run_agent_run_id_get_1**](docs/AgentsApi.md#get_agent_run_v1_organizations_org_id_agent_run_agent_run_id_get_1) | **GET** /v1/organizations/{org_id}/agent/run/{agent_run_id} | Get Agent Run
*OrganizationsApi* | [**get_organizations_v1_organizations_get**](docs/OrganizationsApi.md#get_organizations_v1_organizations_get) | **GET** /v1/organizations | Get Organizations
*OrganizationsApi* | [**get_organizations_v1_organizations_get_0**](docs/OrganizationsApi.md#get_organizations_v1_organizations_get_0) | **GET** /v1/organizations | Get Organizations
*OrganizationsApi* | [**get_organizations_v1_organizations_get_1**](docs/OrganizationsApi.md#get_organizations_v1_organizations_get_1) | **GET** /v1/organizations | Get Organizations
*UsersApi* | [**get_user_v1_organizations_org_id_users_user_id_get**](docs/UsersApi.md#get_user_v1_organizations_org_id_users_user_id_get) | **GET** /v1/organizations/{org_id}/users/{user_id} | Get User
*UsersApi* | [**get_user_v1_organizations_org_id_users_user_id_get_0**](docs/UsersApi.md#get_user_v1_organizations_org_id_users_user_id_get_0) | **GET** /v1/organizations/{org_id}/users/{user_id} | Get User
*UsersApi* | [**get_user_v1_organizations_org_id_users_user_id_get_1**](docs/UsersApi.md#get_user_v1_organizations_org_id_users_user_id_get_1) | **GET** /v1/organizations/{org_id}/users/{user_id} | Get User
*UsersApi* | [**get_users_v1_organizations_org_id_users_get**](docs/UsersApi.md#get_users_v1_organizations_org_id_users_get) | **GET** /v1/organizations/{org_id}/users | Get Users
*UsersApi* | [**get_users_v1_organizations_org_id_users_get_0**](docs/UsersApi.md#get_users_v1_organizations_org_id_users_get_0) | **GET** /v1/organizations/{org_id}/users | Get Users
*UsersApi* | [**get_users_v1_organizations_org_id_users_get_1**](docs/UsersApi.md#get_users_v1_organizations_org_id_users_get_1) | **GET** /v1/organizations/{org_id}/users | Get Users


## Documentation For Models

 - [AgentRunResponse](docs/AgentRunResponse.md)
 - [CreateAgentRunInput](docs/CreateAgentRunInput.md)
 - [FastAPIRateLimitResponse](docs/FastAPIRateLimitResponse.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [OrganizationResponse](docs/OrganizationResponse.md)
 - [OrganizationSettings](docs/OrganizationSettings.md)
 - [PageOrganizationResponse](docs/PageOrganizationResponse.md)
 - [PageUserResponse](docs/PageUserResponse.md)
 - [UserResponse](docs/UserResponse.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




