# JSON Loader

This loader extracts the text in a formatted manner from a JSON file. A single local file is passed in each time you call `load_data`.

## Usage

To use this loader, you need to pass in a `Path` to a local file.

```python
from pathlib import Path
from dotagent import download_loader

JSONReader = download_loader("JSONReader")

loader = JSONReader()
documents = loader.load_data(Path('./data.json'))
```

This loader is designed to be used as a way to load data into [LlamaIndex](https://github.com/jerryjliu/gpt_index/tree/main/gpt_index) and/or subsequently used as a Tool in a [LangChain](https://github.com/hwchase17/langchain) Agent. See [here](https://github.com/emptycrown/llama-hub/tree/main) for examples.
