# Kibela Reader

This reader fetches article from your [Kibela](https://kibe.la/) notes using the GraphQL API.

# Usage

Here's an example of how to use it. You can get your access token from [here](https://my.kibe.la/settings/access_tokens).

```python
import os
from llama_hub.kibela.base import KibelaReader

team = os.environ["KIBELA_TEAM"]
token = os.environ["KIBELA_TOKEN"]

reader = KibelaReader(team=team, token=token)
documents = reader.load_data()
```

Alternately, you can also use download_loader from dotagent

```python
import os
from dotagent import download_loader
KibelaReader = download_loader('KibelaReader')

team = os.environ["KIBELA_TEAM"]
token = os.environ["KIBELA_TOKEN"]

reader = KibelaReader(team=team, token=token)
documents = reader.load_data()
```
