"""
CodeMie SDK for Python
~~~~~~~~~~~~~~~~~~~~~

A Python SDK for interacting with CodeMie API.

Basic usage:

    >>> from codemie_sdk import CodeMieClient
    >>> client = CodeMieClient(
    ...     auth_server_url="https://auth.example.com",
    ...     auth_client_id="client_id",
    ...     auth_client_secret="secret",
    ...     auth_realm_name="realm",
    ...     codemie_api_domain="api.codemie.com"
    ... )
    >>> assistants = client.assistants.list()
"""

from .client.client import CodeMieClient
from .models.vendor_assistant import (
    VendorType,
    VendorAssistantSetting,
    VendorAssistantSettingsResponse,
    VendorAssistant,
    VendorAssistantVersion,
    VendorAssistantStatus,
    VendorAssistantsResponse,
    VendorAssistantAlias,
    VendorAssistantAliasesResponse,
    VendorAssistantInstallRequest,
    VendorAssistantInstallSummary,
    VendorAssistantInstallResponse,
    VendorAssistantUninstallResponse,
    PaginationInfo,
    TokenPagination,
)
from .services.vendor import VendorService

__version__ = "0.2.9"
__all__ = [
    "CodeMieClient",
    "VendorType",
    "VendorAssistantSetting",
    "VendorAssistantSettingsResponse",
    "VendorAssistant",
    "VendorAssistantVersion",
    "VendorAssistantStatus",
    "VendorAssistantsResponse",
    "VendorAssistantAlias",
    "VendorAssistantAliasesResponse",
    "VendorAssistantInstallRequest",
    "VendorAssistantInstallSummary",
    "VendorAssistantInstallResponse",
    "VendorAssistantUninstallResponse",
    "PaginationInfo",
    "TokenPagination",
    "VendorService",
]
