# CodeViewX Technical Documentation

## Document Structure
- README.md - This file, overview and navigation
- 01-overview.md - Project overview and technology stack
- 02-quickstart.md - Quick start guide and basic usage
- 03-architecture.md - System architecture and component design
- 04-core-mechanisms.md - Core working mechanisms and workflows
- 05-data-models.md - Data structures and models
- 06-api-reference.md - API documentation and interfaces
- 07-development-guide.md - Development setup and guidelines
- 08-testing.md - Testing strategy and guidelines

## Documentation Metadata
- Generated Time: 2025-06-17 15:30:00
- Analysis Scope: 45 files, 8,500+ lines of code
- Main Technology Stack: Python 3.8+, LangChain, DeepAgents, Flask, ripgrep

## Quick Navigation

### For Users
- [Getting Started](02-quickstart.md) - Installation and basic usage
- [API Reference](06-api-reference.md) - Complete API documentation

### For Developers
- [Project Overview](01-overview.md) - High-level project understanding
- [Architecture](03-architecture.md) - System design and components
- [Core Mechanisms](04-core-mechanisms.md) - Detailed workflow analysis
- [Development Guide](07-development-guide.md) - Setup and contribution guidelines

### For Maintainers
- [Testing](08-testing.md) - Testing strategy and implementation
- [Data Models](05-data-models.md) - Internal data structures

## About CodeViewX

CodeViewX is an AI-powered code documentation generator that automatically analyzes codebases and generates comprehensive technical documentation. The project leverages modern AI technologies including LangChain, DeepAgents, and Anthropic Claude to provide intelligent code analysis and documentation generation.

### Key Features
- 🤖 AI-powered code analysis using DeepAgents framework
- 📝 Comprehensive multi-chapter documentation generation
- 🌐 Multi-language support (Chinese, English, Japanese, Korean, French, German, Spanish, Russian)
- 🖥️ Built-in web server for documentation browsing
- ⚡ Fast code search with ripgrep integration
- 🔧 CLI tool and Python API support

### Project Statistics
- **Version**: 0.2.2
- **License**: GPL-3.0-or-later
- **Python Support**: 3.8+
- **Core Dependencies**: 13 main packages
- **Test Coverage**: Comprehensive test suite with pytest

## Getting Help

- 📖 Browse this documentation for detailed information
- 🐛 Report issues on [GitHub](https://github.com/dean2021/codeviewx/issues)
- 💬 Join discussions on [GitHub Discussions](https://github.com/dean2021/codeviewx/discussions)
- 📧 Contact: dean@csoio.com

---

*This documentation was automatically generated by CodeViewX using AI analysis of the codebase.*