# CodeViewX Technical Documentation

> This documentation is automatically generated by CodeViewX based on code analysis.

## Document Structure

| Document | Description | Target Audience |
|----------|-------------|----------------|
| [Project Overview](./01-overview.md) | Project introduction, technology stack, directory structure | Everyone |
| [Quick Start](./02-quickstart.md) | Environment setup, installation, running steps | Beginners |
| [System Architecture](./03-architecture.md) | Architecture design, module description | Developers, Architects |
| [Core Mechanisms](./04-core-mechanisms.md) | Deep analysis of core functionality | Developers |
| [API Reference](./06-api-reference.md) | Complete API documentation | Developers |
| [Development Guide](./07-development-guide.md) | How to add features, development workflow | Contributors |
| [Testing Documentation](./08-testing.md) | Testing strategy, how to write tests | Developers |
| [Security Analysis](./09-security.md) | Security considerations, risk analysis | Developers, Security Team |
| [Performance & Optimization](./10-performance.md) | Performance analysis, optimization suggestions | Developers, DevOps |
| [Deployment Guide](./11-deployment.md) | Deployment architecture, CI/CD | DevOps, System Admins |
| [Troubleshooting](./12-troubleshooting.md) | Common issues, FAQ | All Users |

## Document Metadata

- **Generation Time**: 2025-06-17 10:30:00
- **Project Type**: CLI Tool / Documentation Generator
- **Analysis Scope**: Core modules + main business logic
- **Code Version**: Current development branch
- **Analysis Tool**: CodeViewX v0.2.0

## Quick Navigation

- **I'm a beginner** → Start with [Quick Start](./02-quickstart.md)
- **Want to understand the design** → Check [System Architecture](./03-architecture.md)
- **Need to develop** → Read [Development Guide](./07-development-guide.md)
- **Having issues** → Check [Troubleshooting](./12-troubleshooting.md)

## How to Use This Documentation

1. Read documents in numerical order for progressive learning
2. Selectively read based on "Target Audience" suggestions
3. Use document links for quick navigation
4. Code references in documents can directly jump to source code

## Project Summary

CodeViewX is an AI-powered intelligent code documentation generator based on Anthropic Claude and DeepAgents framework. It automatically analyzes codebases and generates professional technical documentation with support for multiple languages.

**Key Features**:
- 🤖 AI-powered analysis using Claude, DeepAgents, and LangChain
- 📝 Automatic generation of 8 core technical documentation chapters
- 🌐 Multi-language support (8 languages)
- 🖥️ Built-in web server with beautiful documentation browsing interface
- ⚡ High-performance code search with ripgrep integration

**Technology Stack**:
- **Language**: Python 3.8+
- **AI Framework**: LangChain, LangGraph, DeepAgents
- **Web Framework**: Flask
- **Code Search**: ripgrep
- **Documentation**: Markdown with Mermaid diagram support

**Project Type**: CLI Tool / Documentation Generator
**License**: GPL-3.0-or-later
**Version**: 0.2.0

For more information about the project, visit the [GitHub repository](https://github.com/dean2021/codeviewx).