# coding: utf-8

"""
    Codex API

    List of endpoints and interfaces available to Codex API users

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from codex_api_client.models.reservation import Reservation
from codex_api_client.models.storage_request import StorageRequest
from typing import Optional, Set
from typing_extensions import Self

class SlotAgent(BaseModel):
    """
    SlotAgent
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Keccak hash of the abi encoded tuple (RequestId, slot index)")
    slot_index: Optional[StrictStr] = Field(default=None, description="Slot Index as decimal string", alias="slotIndex")
    request_id: Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]] = Field(default=None, description="32bits identifier encoded in hex-decimal string.", alias="requestId")
    request: Optional[StorageRequest] = None
    reservation: Optional[Reservation] = None
    state: Optional[StrictStr] = Field(default=None, description="Description of the slot's")
    __properties: ClassVar[List[str]] = ["id", "slotIndex", "requestId", "request", "reservation", "state"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SaleCancelled', 'SaleDownloading', 'SaleErrored', 'SaleFailed', 'SaleFilled', 'SaleFilling', 'SaleFinished', 'SaleIgnored', 'SaleInitialProving', 'SalePayout', 'SalePreparing', 'SaleProving', 'SaleUnknown']):
            raise ValueError("must be one of enum values ('SaleCancelled', 'SaleDownloading', 'SaleErrored', 'SaleFailed', 'SaleFilled', 'SaleFilling', 'SaleFinished', 'SaleIgnored', 'SaleInitialProving', 'SalePayout', 'SalePreparing', 'SaleProving', 'SaleUnknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SlotAgent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of request
        if self.request:
            _dict['request'] = self.request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reservation
        if self.reservation:
            _dict['reservation'] = self.reservation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SlotAgent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "slotIndex": obj.get("slotIndex"),
            "requestId": obj.get("requestId"),
            "request": StorageRequest.from_dict(obj["request"]) if obj.get("request") is not None else None,
            "reservation": Reservation.from_dict(obj["reservation"]) if obj.get("reservation") is not None else None,
            "state": obj.get("state")
        })
        return _obj


