# coding: utf-8

"""
    Codex API

    List of endpoints and interfaces available to Codex API users

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from codex_api_client.models.content import Content
from codex_api_client.models.storage_ask import StorageAsk
from typing import Optional, Set
from typing_extensions import Self

class StorageRequest(BaseModel):
    """
    StorageRequest
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Request ID")
    client: Optional[StrictStr] = Field(default=None, description="Address of Ethereum address")
    ask: Optional[StorageAsk] = None
    content: Optional[Content] = None
    expiry: Optional[StrictStr] = Field(default='10 minutes', description="A timestamp as seconds since unix epoch at which this request expires if the Request does not find requested amount of nodes to host the data.")
    nonce: Optional[StrictStr] = Field(default=None, description="Random data")
    __properties: ClassVar[List[str]] = ["id", "client", "ask", "content", "expiry", "nonce"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StorageRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ask
        if self.ask:
            _dict['ask'] = self.ask.to_dict()
        # override the default output from pydantic by calling `to_dict()` of content
        if self.content:
            _dict['content'] = self.content.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StorageRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "client": obj.get("client"),
            "ask": StorageAsk.from_dict(obj["ask"]) if obj.get("ask") is not None else None,
            "content": Content.from_dict(obj["content"]) if obj.get("content") is not None else None,
            "expiry": obj.get("expiry") if obj.get("expiry") is not None else '10 minutes',
            "nonce": obj.get("nonce")
        })
        return _obj


