# coding: utf-8

"""
    Codex API

    List of endpoints and interfaces available to Codex API users

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SalesAvailability(BaseModel):
    """
    SalesAvailability
    """ # noqa: E501
    total_size: StrictInt = Field(description="Total size of availability's storage in bytes", alias="totalSize")
    duration: StrictInt = Field(description="The duration of the request in seconds")
    min_price_per_byte_per_second: StrictStr = Field(description="Minimal price per byte per second paid (in amount of tokens) for the hosted request's slot for the request's duration as decimal string", alias="minPricePerBytePerSecond")
    total_collateral: StrictStr = Field(description="Total collateral (in amount of tokens) that can be used for matching requests", alias="totalCollateral")
    enabled: Optional[StrictBool] = Field(default=True, description="Enable the ability to receive sales on this availability.")
    until: Optional[StrictInt] = Field(default=0, description="Specifies the latest timestamp, after which the availability will no longer host any slots. If set to 0, there will be no restrictions.")
    __properties: ClassVar[List[str]] = ["totalSize", "duration", "minPricePerBytePerSecond", "totalCollateral", "enabled", "until"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SalesAvailability from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SalesAvailability from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "totalSize": obj.get("totalSize"),
            "duration": obj.get("duration"),
            "minPricePerBytePerSecond": obj.get("minPricePerBytePerSecond"),
            "totalCollateral": obj.get("totalCollateral"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "until": obj.get("until") if obj.get("until") is not None else 0
        })
        return _obj


