# codex-api-client
List of endpoints and interfaces available to Codex API users

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 0.4.0
- Generator version: 7.12.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation

```sh
pip install codex_api_client
```

Then import the package:
```python
import codex_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import codex_api_client
from codex_api_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:8080/api/codex/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = codex_api_client.Configuration(
    host = "http://localhost:8080/api/codex/v1"
)



# Enter a context with an instance of the API client
with codex_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = codex_api_client.DataApi(api_client)
    cid = 'cid_example' # str | Block or dataset to be deleted.

    try:
        # Deletes either a single block or an entire dataset from the local node.
        api_instance.delete_local(cid)
    except ApiException as e:
        print("Exception when calling DataApi->delete_local: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080/api/codex/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataApi* | [**delete_local**](docs/DataApi.md#delete_local) | **DELETE** /data/{cid} | Deletes either a single block or an entire dataset from the local node.
*DataApi* | [**download_local**](docs/DataApi.md#download_local) | **GET** /data/{cid} | Download a file from the local node in a streaming manner. If the file is not available locally, a 404 is returned.
*DataApi* | [**download_network**](docs/DataApi.md#download_network) | **POST** /data/{cid}/network | Download a file from the network to the local node if it&#39;s not available locally. Note: Download is performed async. Call can return before download is completed.
*DataApi* | [**download_network_manifest**](docs/DataApi.md#download_network_manifest) | **GET** /data/{cid}/network/manifest | Download only the dataset manifest from the network to the local node if it&#39;s not available locally.
*DataApi* | [**download_network_stream**](docs/DataApi.md#download_network_stream) | **GET** /data/{cid}/network/stream | Download a file from the network in a streaming manner. If the file is not available locally, it will be retrieved from other nodes in the network if able.
*DataApi* | [**list_data**](docs/DataApi.md#list_data) | **GET** /data | Lists manifest CIDs stored locally in node.
*DataApi* | [**space**](docs/DataApi.md#space) | **GET** /space | Gets a summary of the storage space allocation of the node.
*DataApi* | [**upload**](docs/DataApi.md#upload) | **POST** /data | Upload a file in a streaming manner. Once finished, the file is stored in the node and can be retrieved by any node in the network using the returned CID.
*DebugApi* | [**get_debug_info**](docs/DebugApi.md#get_debug_info) | **GET** /debug/info | Gets node information
*DebugApi* | [**set_debug_log_level**](docs/DebugApi.md#set_debug_log_level) | **POST** /debug/chronicles/loglevel | Set log level at run time
*MarketplaceApi* | [**create_storage_request**](docs/MarketplaceApi.md#create_storage_request) | **POST** /storage/request/{cid} | Creates a new Request for storage
*MarketplaceApi* | [**get_active_slot_by_id**](docs/MarketplaceApi.md#get_active_slot_by_id) | **GET** /sales/slots/{slotId} | Returns active slot with id {slotId} for the host
*MarketplaceApi* | [**get_active_slots**](docs/MarketplaceApi.md#get_active_slots) | **GET** /sales/slots | Returns active slots
*MarketplaceApi* | [**get_availabilities**](docs/MarketplaceApi.md#get_availabilities) | **GET** /sales/availability | Returns storage that is for sale
*MarketplaceApi* | [**get_purchase**](docs/MarketplaceApi.md#get_purchase) | **GET** /storage/purchases/{id} | Returns purchase details
*MarketplaceApi* | [**get_purchases**](docs/MarketplaceApi.md#get_purchases) | **GET** /storage/purchases | Returns list of purchase IDs
*MarketplaceApi* | [**get_reservations**](docs/MarketplaceApi.md#get_reservations) | **GET** /sales/availability/{id}/reservations | Get availability&#39;s reservations
*MarketplaceApi* | [**offer_storage**](docs/MarketplaceApi.md#offer_storage) | **POST** /sales/availability | Offers storage for sale
*MarketplaceApi* | [**update_offered_storage**](docs/MarketplaceApi.md#update_offered_storage) | **PATCH** /sales/availability/{id} | Updates availability
*NodeApi* | [**connect_peer**](docs/NodeApi.md#connect_peer) | **GET** /connect/{peerId} | Connect to a peer
*NodeApi* | [**get_peer_id**](docs/NodeApi.md#get_peer_id) | **GET** /peerid | Get Node&#39;s PeerID
*NodeApi* | [**get_spr**](docs/NodeApi.md#get_spr) | **GET** /spr | Get Node&#39;s SPR


## Documentation For Models

 - [CodexVersion](docs/CodexVersion.md)
 - [Content](docs/Content.md)
 - [DataItem](docs/DataItem.md)
 - [DataList](docs/DataList.md)
 - [DebugInfo](docs/DebugInfo.md)
 - [ManifestItem](docs/ManifestItem.md)
 - [Node](docs/Node.md)
 - [PeerIdRead](docs/PeerIdRead.md)
 - [PeersTable](docs/PeersTable.md)
 - [Purchase](docs/Purchase.md)
 - [Reservation](docs/Reservation.md)
 - [SPRRead](docs/SPRRead.md)
 - [SalesAvailability](docs/SalesAvailability.md)
 - [SalesAvailabilityREAD](docs/SalesAvailabilityREAD.md)
 - [Slot](docs/Slot.md)
 - [SlotAgent](docs/SlotAgent.md)
 - [Space](docs/Space.md)
 - [StorageAsk](docs/StorageAsk.md)
 - [StorageRequest](docs/StorageRequest.md)
 - [StorageRequestCreation](docs/StorageRequestCreation.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




