# coding: utf-8

"""
    Codex API

    List of endpoints and interfaces available to Codex API users

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from codex_api_client.models.storage_request import StorageRequest
from typing import Optional, Set
from typing_extensions import Self

class Purchase(BaseModel):
    """
    Purchase
    """ # noqa: E501
    state: StrictStr = Field(description="Description of the Request's state")
    error: Optional[StrictStr] = Field(default=None, description="If Request failed, then here is presented the error message")
    request: Optional[StorageRequest] = None
    request_id: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="32bits identifier encoded in hex-decimal string.", alias="requestId")
    __properties: ClassVar[List[str]] = ["state", "error", "request", "requestId"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['cancelled', 'errored', 'failed', 'finished', 'pending', 'started', 'submitted', 'unknown']):
            raise ValueError("must be one of enum values ('cancelled', 'errored', 'failed', 'finished', 'pending', 'started', 'submitted', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Purchase from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of request
        if self.request:
            _dict['request'] = self.request.to_dict()
        # set to None if error (nullable) is None
        # and model_fields_set contains the field
        if self.error is None and "error" in self.model_fields_set:
            _dict['error'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Purchase from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "state": obj.get("state"),
            "error": obj.get("error"),
            "request": StorageRequest.from_dict(obj["request"]) if obj.get("request") is not None else None,
            "requestId": obj.get("requestId")
        })
        return _obj


