# generated by datamodel-codegen:
# ruff: noqa: F821
#   filename:  protocol.schema.json

from __future__ import annotations

from enum import Enum
from typing import Any, Literal

from pydantic import ConfigDict, Field, RootModel

from codex.protocol._base_model import BaseModelWithExtras


class Model(RootModel[Any]):
    root: Any


class AddConversationSubscriptionResponse(BaseModelWithExtras):
    subscriptionId: str


class AgentMessageDeltaEvent(BaseModelWithExtras):
    delta: str


class AgentMessageEvent(BaseModelWithExtras):
    message: str


class AgentReasoningDeltaEvent(BaseModelWithExtras):
    delta: str


class AgentReasoningEvent(BaseModelWithExtras):
    text: str


class AgentReasoningRawContentDeltaEvent(BaseModelWithExtras):
    delta: str


class AgentReasoningRawContentEvent(BaseModelWithExtras):
    text: str


class AskForApproval(Enum):
    untrusted = "untrusted"
    on_failure = "on-failure"
    on_request = "on-request"
    never = "never"


class AuthMode(Enum):
    apikey = "apikey"
    chatgpt = "chatgpt"


class AuthStatusChangeNotification(BaseModelWithExtras):
    authMethod: AuthMode | None = Field(
        None, description="Current authentication method; omitted if signed out."
    )


class BackgroundEventEvent(BaseModelWithExtras):
    message: str


class BlobResourceContents(BaseModelWithExtras):
    blob: str
    mimeType: str | None = None
    uri: str


class CancelLoginChatGptParams(BaseModelWithExtras):
    loginId: str


class ContentItem1(BaseModelWithExtras):
    text: str
    type: Literal["input_text"]


class ContentItem2(BaseModelWithExtras):
    image_url: str
    type: Literal["input_image"]


class ContentItem3(BaseModelWithExtras):
    text: str
    type: Literal["output_text"]


class ContentItem(RootModel[ContentItem1 | ContentItem2 | ContentItem3]):
    root: ContentItem1 | ContentItem2 | ContentItem3


class ConversationId(RootModel[str]):
    root: str


class ConversationSummary(BaseModelWithExtras):
    conversationId: ConversationId
    path: str
    preview: str
    timestamp: str | None = Field(
        None,
        description="RFC3339 timestamp string for the session start, if available.",
    )


class CustomPrompt(BaseModelWithExtras):
    content: str
    name: str
    path: str


class ErrorEvent(BaseModelWithExtras):
    message: str


class ExecApprovalRequestEvent(BaseModelWithExtras):
    call_id: str = Field(..., description="Identifier for the associated exec call, if available.")
    command: list[str] = Field(..., description="The command to be executed.")
    cwd: str = Field(..., description="The command's working directory.")
    reason: str | None = Field(
        None,
        description="Optional human-readable reason for the approval (e.g. retry without sandbox).",
    )


class ExecCommandApprovalParams(BaseModelWithExtras):
    call_id: str = Field(
        ...,
        description="Use to correlate this with [codex_core::protocol::ExecCommandBeginEvent] and [codex_core::protocol::ExecCommandEndEvent].",
    )
    command: list[str]
    conversation_id: ConversationId
    cwd: str
    reason: str | None = None


class Duration(BaseModelWithExtras):
    model_config = ConfigDict(
        extra="forbid",
    )
    secs: int
    nanos: int


class ExecCommandEndEvent(BaseModelWithExtras):
    aggregated_output: str = Field(..., description="Captured aggregated output")
    call_id: str = Field(..., description="Identifier for the ExecCommandBegin that finished.")
    duration: str | Duration
    exit_code: int = Field(..., description="The command's exit code.")
    formatted_output: str = Field(
        ..., description="Formatted output from the command, as seen by the model."
    )
    stderr: str = Field(..., description="Captured stderr")
    stdout: str = Field(..., description="Captured stdout")


class ExecOutputStream(Enum):
    stdout = "stdout"
    stderr = "stderr"


class Add(BaseModelWithExtras):
    content: str


class FileChange1(BaseModelWithExtras):
    add: Add


class Delete(BaseModelWithExtras):
    content: str


class FileChange2(BaseModelWithExtras):
    delete: Delete


class Update(BaseModelWithExtras):
    move_path: str | None = None
    unified_diff: str


class FileChange3(BaseModelWithExtras):
    update: Update


class FileChange(RootModel[FileChange1 | FileChange2 | FileChange3]):
    root: FileChange1 | FileChange2 | FileChange3


class FunctionCallOutputPayload(BaseModelWithExtras):
    content: str
    success: bool | None = None


class GetAuthStatusParams(BaseModelWithExtras):
    includeToken: bool | None = Field(
        None,
        description="If true, include the current auth token (if available) in the response.",
    )
    refreshToken: bool | None = Field(
        None,
        description="If true, attempt to refresh the token before returning status.",
    )


class GetAuthStatusResponse(BaseModelWithExtras):
    authMethod: AuthMode | None = None
    authToken: str | None = None
    preferredAuthMethod: AuthMode


class GetUserAgentResponse(BaseModelWithExtras):
    userAgent: str


class GitDiffToRemoteParams(BaseModelWithExtras):
    cwd: str


class GitSha(RootModel[str]):
    root: str


class HistoryEntry(BaseModelWithExtras):
    conversation_id: str
    text: str
    ts: float


class InputMessageKind(Enum):
    plain = "plain"
    user_instructions = "user_instructions"
    environment_context = "environment_context"


class InterruptConversationParams(BaseModelWithExtras):
    conversationId: ConversationId


class JsonValue(RootModel[float | str | bool | list["JsonValue"] | dict[str, "JsonValue"] | None]):
    root: float | str | bool | list[JsonValue] | dict[str, JsonValue] | None


class ListConversationsParams(BaseModelWithExtras):
    cursor: str | None = Field(
        None, description="Opaque pagination cursor returned by a previous call."
    )
    pageSize: float | None = Field(
        None,
        description="Optional page size; defaults to a reasonable server-side value.",
    )


class ListConversationsResponse(BaseModelWithExtras):
    items: list[ConversationSummary]
    nextCursor: str | None = Field(
        None,
        description="Opaque cursor to pass to the next call to continue after the last item. if None, there are no more items to return.",
    )


class ListCustomPromptsResponseEvent(BaseModelWithExtras):
    custom_prompts: list[CustomPrompt]


class LocalShellAction(BaseModelWithExtras):
    command: list[str]
    env: dict[str, str] | None = None
    timeout_ms: float | None = None
    type: Literal["exec"]
    user: str | None = None
    working_directory: str | None = None


class LocalShellExecAction(BaseModelWithExtras):
    command: list[str]
    env: dict[str, str] | None = None
    timeout_ms: float | None = None
    user: str | None = None
    working_directory: str | None = None


class LocalShellStatus(Enum):
    completed = "completed"
    in_progress = "in_progress"
    incomplete = "incomplete"


class LoginChatGptCompleteNotification(BaseModelWithExtras):
    error: str | None = None
    loginId: str
    success: bool


class LoginChatGptResponse(BaseModelWithExtras):
    authUrl: str = Field(
        ...,
        description="URL the client should open in a browser to initiate the OAuth flow.",
    )
    loginId: str


class McpInvocation(BaseModelWithExtras):
    arguments: JsonValue | None = Field(None, description="Arguments to the tool call.")
    server: str = Field(..., description="Name of the MCP server as defined in the config.")
    tool: str = Field(..., description="Name of the tool as given by the MCP server.")


class McpServerInfo(BaseModelWithExtras):
    name: str
    title: str | None = None
    user_agent: str
    version: str


class McpToolCallBeginEvent(BaseModelWithExtras):
    call_id: str = Field(
        ...,
        description="Identifier so this can be paired with the McpToolCallEnd event.",
    )
    invocation: McpInvocation


class Result1(BaseModelWithExtras):
    Err: str


class NewConversationResponse(BaseModelWithExtras):
    conversationId: ConversationId
    model: str
    rolloutPath: str


class ParsedCommand1(BaseModelWithExtras):
    cmd: str
    name: str
    type: Literal["read"]


class ParsedCommand2(BaseModelWithExtras):
    cmd: str
    path: str | None = None
    type: Literal["list_files"]


class ParsedCommand3(BaseModelWithExtras):
    cmd: str
    path: str | None = None
    query: str | None = None
    type: Literal["search"]


class ParsedCommand4(BaseModelWithExtras):
    cmd: str
    type: Literal["unknown"]


class ParsedCommand(RootModel[ParsedCommand1 | ParsedCommand2 | ParsedCommand3 | ParsedCommand4]):
    root: ParsedCommand1 | ParsedCommand2 | ParsedCommand3 | ParsedCommand4


class PatchApplyBeginEvent(BaseModelWithExtras):
    auto_approved: bool = Field(
        ...,
        description="If true, there was no ApplyPatchApprovalRequest for this patch.",
    )
    call_id: str = Field(
        ...,
        description="Identifier so this can be paired with the PatchApplyEnd event.",
    )
    changes: dict[str, FileChange] = Field(..., description="The changes to be applied.")


class PatchApplyEndEvent(BaseModelWithExtras):
    call_id: str = Field(..., description="Identifier for the PatchApplyBegin that finished.")
    stderr: str = Field(..., description="Captured stderr (parser errors, IO failures, etc.).")
    stdout: str = Field(..., description="Captured stdout (summary printed by apply_patch).")
    success: bool = Field(..., description="Whether the patch was applied successfully.")


class ReasoningEffort(Enum):
    minimal = "minimal"
    low = "low"
    medium = "medium"
    high = "high"


class ReasoningItemContent1(BaseModelWithExtras):
    text: str
    type: Literal["reasoning_text"]


class ReasoningItemContent2(BaseModelWithExtras):
    text: str
    type: Literal["text"]


class ReasoningItemContent(RootModel[ReasoningItemContent1 | ReasoningItemContent2]):
    root: ReasoningItemContent1 | ReasoningItemContent2


class ReasoningItemReasoningSummary(BaseModelWithExtras):
    text: str
    type: Literal["summary_text"]


class ReasoningSummary(Enum):
    auto = "auto"
    concise = "concise"
    detailed = "detailed"
    none = "none"


class RecordStringNever(RootModel[dict[str, Any] | None]):
    root: dict[str, Any] | None = None


class RemoveConversationListenerParams(BaseModelWithExtras):
    subscriptionId: str


class RequestId(RootModel[str | int]):
    root: str | int


class ResponseItem1(BaseModelWithExtras):
    content: list[ContentItem]
    id: str | None = None
    role: str
    type: Literal["message"]


class ResponseItem2(BaseModelWithExtras):
    content: list[ReasoningItemContent] | None = None
    encrypted_content: str | None = None
    id: str | None = None
    summary: list[ReasoningItemReasoningSummary]
    type: Literal["reasoning"]


class ResponseItem3(BaseModelWithExtras):
    action: LocalShellAction
    call_id: str | None = Field(None, description="Set when using the Responses API.")
    id: str | None = Field(None, description="Set when using the chat completions API.")
    status: LocalShellStatus
    type: Literal["local_shell_call"]


class ResponseItem4(BaseModelWithExtras):
    arguments: str
    call_id: str
    id: str | None = None
    name: str
    type: Literal["function_call"]


class ResponseItem5(BaseModelWithExtras):
    call_id: str
    output: FunctionCallOutputPayload
    type: Literal["function_call_output"]


class ResponseItem6(BaseModelWithExtras):
    call_id: str
    id: str | None = None
    input: str
    name: str
    status: str | None = None
    type: Literal["custom_tool_call"]


class ResponseItem7(BaseModelWithExtras):
    call_id: str
    output: str
    type: Literal["custom_tool_call_output"]


class ResponseItem9(BaseModelWithExtras):
    type: Literal["other"]


class ReviewDecision(Enum):
    approved = "approved"
    approved_for_session = "approved_for_session"
    denied = "denied"
    abort = "abort"


class Role(Enum):
    assistant = "assistant"
    user = "user"


class SandboxMode(Enum):
    read_only = "read-only"
    workspace_write = "workspace-write"
    danger_full_access = "danger-full-access"


class SandboxPolicy1(BaseModelWithExtras):
    mode: Literal["danger-full-access"]


class SandboxPolicy2(BaseModelWithExtras):
    mode: Literal["read-only"]


class SandboxPolicy3(BaseModelWithExtras):
    exclude_slash_tmp: bool = Field(
        ...,
        description="When set to `true`, will NOT include the `/tmp` among the default writable roots on UNIX. Defaults to `false`.",
    )
    exclude_tmpdir_env_var: bool = Field(
        ...,
        description="When set to `true`, will NOT include the per-user `TMPDIR` environment variable among the default writable roots. Defaults to `false`.",
    )
    mode: Literal["workspace-write"]
    network_access: bool = Field(
        ...,
        description="When set to `true`, outbound network access is allowed. `false` by default.",
    )
    writable_roots: list[str] | None = Field(
        None,
        description="Additional folders (beyond cwd and possibly TMPDIR) that should be writable from within the sandbox.",
    )


class SandboxPolicy(RootModel[SandboxPolicy1 | SandboxPolicy2 | SandboxPolicy3]):
    root: SandboxPolicy1 | SandboxPolicy2 | SandboxPolicy3 = Field(
        ..., description="Determines execution restrictions for model shell commands."
    )


class SandboxSettings(BaseModelWithExtras):
    excludeSlashTmp: bool | None = None
    excludeTmpdirEnvVar: bool | None = None
    networkAccess: bool | None = None
    writableRoots: list[str]


class ServerCapabilitiesPrompts(BaseModelWithExtras):
    listChanged: bool | None = None


class ServerCapabilitiesResources(BaseModelWithExtras):
    listChanged: bool | None = None
    subscribe: bool | None = None


class ServerCapabilitiesTools(BaseModelWithExtras):
    listChanged: bool | None = None


class StepStatus(Enum):
    pending = "pending"
    in_progress = "in_progress"
    completed = "completed"


class StreamErrorEvent(BaseModelWithExtras):
    message: str


class TaskCompleteEvent(BaseModelWithExtras):
    last_agent_message: str | None = None


class TaskStartedEvent(BaseModelWithExtras):
    model_context_window: int | None = None


class TextResourceContents(BaseModelWithExtras):
    mimeType: str | None = None
    text: str
    uri: str


class TokenUsage(BaseModelWithExtras):
    cached_input_tokens: int
    input_tokens: int
    output_tokens: int
    reasoning_output_tokens: int
    total_tokens: int


class TokenUsageInfo(BaseModelWithExtras):
    last_token_usage: TokenUsage
    model_context_window: int | None = None
    total_token_usage: TokenUsage


class ToolAnnotations(BaseModelWithExtras):
    destructiveHint: bool | None = None
    idempotentHint: bool | None = None
    openWorldHint: bool | None = None
    readOnlyHint: bool | None = None
    title: str | None = None


class ToolInputSchema(BaseModelWithExtras):
    properties: JsonValue | None = None
    required: list[str] | None = None
    type: str


class ToolOutputSchema(BaseModelWithExtras):
    properties: JsonValue | None = None
    required: list[str] | None = None
    type: str


class Tools(BaseModelWithExtras):
    viewImage: bool | None = None
    webSearch: bool | None = None


class TurnAbortReason(Enum):
    interrupted = "interrupted"
    replaced = "replaced"


class TurnAbortedEvent(BaseModelWithExtras):
    reason: TurnAbortReason


class TurnDiffEvent(BaseModelWithExtras):
    unified_diff: str


class UserMessageEvent(BaseModelWithExtras):
    kind: InputMessageKind | None = None
    message: str


class Verbosity(Enum):
    low = "low"
    medium = "medium"
    high = "high"


class WebSearchAction1(BaseModelWithExtras):
    query: str
    type: Literal["search"]


class WebSearchAction2(BaseModelWithExtras):
    type: Literal["other"]


class WebSearchAction(RootModel[WebSearchAction1 | WebSearchAction2]):
    root: WebSearchAction1 | WebSearchAction2


class WebSearchBeginEvent(BaseModelWithExtras):
    call_id: str


class WebSearchEndEvent(BaseModelWithExtras):
    call_id: str
    query: str


class EventMsgError(BaseModelWithExtras):
    message: str
    type: Literal["error"]


class EventMsgTaskStarted(BaseModelWithExtras):
    model_context_window: int | None = None
    type: Literal["task_started"]


class EventMsgTaskComplete(BaseModelWithExtras):
    last_agent_message: str | None = None
    type: Literal["task_complete"]


class EventMsgTokenCount(BaseModelWithExtras):
    info: TokenUsageInfo | None = None
    type: Literal["token_count"]


class EventMsgAgentMessage(BaseModelWithExtras):
    message: str
    type: Literal["agent_message"]


class EventMsgUserMessage(BaseModelWithExtras):
    kind: InputMessageKind | None = None
    message: str
    type: Literal["user_message"]


class EventMsgAgentMessageDelta(BaseModelWithExtras):
    delta: str
    type: Literal["agent_message_delta"]


class EventMsgAgentReasoning(BaseModelWithExtras):
    text: str
    type: Literal["agent_reasoning"]


class EventMsgAgentReasoningDelta(BaseModelWithExtras):
    delta: str
    type: Literal["agent_reasoning_delta"]


class EventMsgAgentReasoningRawContent(BaseModelWithExtras):
    text: str
    type: Literal["agent_reasoning_raw_content"]


class EventMsgAgentReasoningRawContentDelta(BaseModelWithExtras):
    delta: str
    type: Literal["agent_reasoning_raw_content_delta"]


class EventMsgAgentReasoningSectionBreak(BaseModelWithExtras):
    type: Literal["agent_reasoning_section_break"]


class EventMsgMcpToolCallBegin(BaseModelWithExtras):
    call_id: str = Field(
        ...,
        description="Identifier so this can be paired with the McpToolCallEnd event.",
    )
    invocation: McpInvocation
    type: Literal["mcp_tool_call_begin"]


class EventMsgWebSearchBegin(BaseModelWithExtras):
    call_id: str
    type: Literal["web_search_begin"]


class EventMsgWebSearchEnd(BaseModelWithExtras):
    call_id: str
    query: str
    type: Literal["web_search_end"]


class EventMsgExecCommandBegin(BaseModelWithExtras):
    call_id: str = Field(
        ...,
        description="Identifier so this can be paired with the ExecCommandEnd event.",
    )
    command: list[str] = Field(..., description="The command to be executed.")
    cwd: str = Field(
        ...,
        description="The command's working directory if not the default cwd for the agent.",
    )
    parsed_cmd: list[ParsedCommand]
    type: Literal["exec_command_begin"]


class EventMsgExecCommandOutputDelta(BaseModelWithExtras):
    call_id: str = Field(
        ..., description="Identifier for the ExecCommandBegin that produced this chunk."
    )
    chunk: str = Field(..., description="Raw bytes from the stream (may not be valid UTF-8).")
    stream: ExecOutputStream = Field(..., description="Which stream produced this chunk.")
    type: Literal["exec_command_output_delta"]


class EventMsgExecCommandEnd(BaseModelWithExtras):
    aggregated_output: str = Field(..., description="Captured aggregated output")
    call_id: str = Field(..., description="Identifier for the ExecCommandBegin that finished.")
    duration: str | Duration
    exit_code: int = Field(..., description="The command's exit code.")
    formatted_output: str = Field(
        ..., description="Formatted output from the command, as seen by the model."
    )
    stderr: str = Field(..., description="Captured stderr")
    stdout: str = Field(..., description="Captured stdout")
    type: Literal["exec_command_end"]


class EventMsgExecApprovalRequest(BaseModelWithExtras):
    call_id: str = Field(..., description="Identifier for the associated exec call, if available.")
    command: list[str] = Field(..., description="The command to be executed.")
    cwd: str = Field(..., description="The command's working directory.")
    reason: str | None = Field(
        None,
        description="Optional human-readable reason for the approval (e.g. retry without sandbox).",
    )
    type: Literal["exec_approval_request"]


class EventMsgApplyPatchApprovalRequest(BaseModelWithExtras):
    call_id: str = Field(
        ...,
        description="Responses API call id for the associated patch apply call, if available.",
    )
    changes: dict[str, FileChange]
    grant_root: str | None = Field(
        None,
        description="When set, the agent is asking the user to allow writes under this root for the remainder of the session.",
    )
    reason: str | None = Field(
        None,
        description="Optional explanatory reason (e.g. request for extra write access).",
    )
    type: Literal["apply_patch_approval_request"]


class EventMsgBackgroundEvent(BaseModelWithExtras):
    message: str
    type: Literal["background_event"]


class EventMsgStreamError(BaseModelWithExtras):
    message: str
    type: Literal["stream_error"]


class EventMsgPatchApplyBegin(BaseModelWithExtras):
    auto_approved: bool = Field(
        ...,
        description="If true, there was no ApplyPatchApprovalRequest for this patch.",
    )
    call_id: str = Field(
        ...,
        description="Identifier so this can be paired with the PatchApplyEnd event.",
    )
    changes: dict[str, FileChange] = Field(..., description="The changes to be applied.")
    type: Literal["patch_apply_begin"]


class EventMsgPatchApplyEnd(BaseModelWithExtras):
    call_id: str = Field(..., description="Identifier for the PatchApplyBegin that finished.")
    stderr: str = Field(..., description="Captured stderr (parser errors, IO failures, etc.).")
    stdout: str = Field(..., description="Captured stdout (summary printed by apply_patch).")
    success: bool = Field(..., description="Whether the patch was applied successfully.")
    type: Literal["patch_apply_end"]


class EventMsgTurnDiff(BaseModelWithExtras):
    type: Literal["turn_diff"]
    unified_diff: str


class EventMsgGetHistoryEntryResponse(BaseModelWithExtras):
    entry: HistoryEntry | None = Field(
        None,
        description="The entry at the requested offset, if available and parseable.",
    )
    log_id: int
    offset: int
    type: Literal["get_history_entry_response"]


class EventMsgListCustomPromptsResponse(BaseModelWithExtras):
    custom_prompts: list[CustomPrompt]
    type: Literal["list_custom_prompts_response"]


class EventMsgTurnAborted(BaseModelWithExtras):
    reason: TurnAbortReason
    type: Literal["turn_aborted"]


class EventMsgShutdownComplete(BaseModelWithExtras):
    type: Literal["shutdown_complete"]


class ClientRequestListConversations(BaseModelWithExtras):
    id: RequestId
    method: Literal["listConversations"]
    params: ListConversationsParams


class ClientRequestInterruptConversation(BaseModelWithExtras):
    id: RequestId
    method: Literal["interruptConversation"]
    params: InterruptConversationParams


class ClientRequestRemoveConversationListener(BaseModelWithExtras):
    id: RequestId
    method: Literal["removeConversationListener"]
    params: RemoveConversationListenerParams


class ClientRequestGitDiffToRemote(BaseModelWithExtras):
    id: RequestId
    method: Literal["gitDiffToRemote"]
    params: GitDiffToRemoteParams


class ClientRequestLoginChatGpt(BaseModelWithExtras):
    id: RequestId
    method: Literal["loginChatGpt"]


class ClientRequestCancelLoginChatGpt(BaseModelWithExtras):
    id: RequestId
    method: Literal["cancelLoginChatGpt"]
    params: CancelLoginChatGptParams


class ClientRequestLogoutChatGpt(BaseModelWithExtras):
    id: RequestId
    method: Literal["logoutChatGpt"]


class ClientRequestGetAuthStatus(BaseModelWithExtras):
    id: RequestId
    method: Literal["getAuthStatus"]
    params: GetAuthStatusParams


class ClientRequestGetUserSavedConfig(BaseModelWithExtras):
    id: RequestId
    method: Literal["getUserSavedConfig"]


class ClientRequestGetUserAgent(BaseModelWithExtras):
    id: RequestId
    method: Literal["getUserAgent"]


class ServerRequestExecCommandApproval(BaseModelWithExtras):
    id: RequestId
    method: Literal["execCommandApproval"]
    params: ExecCommandApprovalParams


class ServerNotificationAuthStatusChange(BaseModelWithExtras):
    method: Literal["authStatusChange"]
    params: AuthStatusChangeNotification


class ServerNotificationLoginChatGptComplete(BaseModelWithExtras):
    method: Literal["loginChatGptComplete"]
    params: LoginChatGptCompleteNotification


class Data(BaseModelWithExtras):
    text: str


class InputItemText(BaseModelWithExtras):
    data: Data
    type: Literal["text"]


class Data1(BaseModelWithExtras):
    image_url: str


class InputItemImage(BaseModelWithExtras):
    data: Data1
    type: Literal["image"]


class Data2(BaseModelWithExtras):
    path: str


class InputItemLocalImage(BaseModelWithExtras):
    data: Data2
    type: Literal["localImage"]


class EmptyObject(RootModel[dict[str, Any] | None]):
    root: dict[str, Any] | None = None


class AddConversationListenerParams(BaseModelWithExtras):
    conversationId: ConversationId


class AgentReasoningSectionBreakEvent(RootModel[EmptyObject]):
    root: EmptyObject


class Annotations(BaseModelWithExtras):
    audience: list[Role] | None = None
    lastModified: str | None = None
    priority: float | None = None


class ApplyPatchApprovalParams(BaseModelWithExtras):
    call_id: str = Field(
        ...,
        description="Use to correlate this with [codex_core::protocol::PatchApplyBeginEvent] and [codex_core::protocol::PatchApplyEndEvent].",
    )
    conversation_id: ConversationId
    file_changes: dict[str, FileChange]
    grant_root: str | None = Field(
        None,
        description="When set, the agent is asking the user to allow writes under this root for the remainder of the session (unclear if this is honored today).",
    )
    reason: str | None = Field(
        None,
        description="Optional explanatory reason (e.g. request for extra write access).",
    )


class ApplyPatchApprovalRequestEvent(BaseModelWithExtras):
    call_id: str = Field(
        ...,
        description="Responses API call id for the associated patch apply call, if available.",
    )
    changes: dict[str, FileChange]
    grant_root: str | None = Field(
        None,
        description="When set, the agent is asking the user to allow writes under this root for the remainder of the session.",
    )
    reason: str | None = Field(
        None,
        description="Optional explanatory reason (e.g. request for extra write access).",
    )


class ApplyPatchApprovalResponse(BaseModelWithExtras):
    decision: ReviewDecision


class ArchiveConversationParams(BaseModelWithExtras):
    conversationId: ConversationId
    rolloutPath: str


class ArchiveConversationResponse(RootModel[EmptyObject]):
    root: EmptyObject


class AudioContent(BaseModelWithExtras):
    annotations: Annotations | None = None
    data: str
    mimeType: str
    type: str


class CancelLoginChatGptResponse(RootModel[EmptyObject]):
    root: EmptyObject


class EmbeddedResourceResource(RootModel[TextResourceContents | BlobResourceContents]):
    root: TextResourceContents | BlobResourceContents


class ExecCommandApprovalResponse(BaseModelWithExtras):
    decision: ReviewDecision


class ExecCommandBeginEvent(BaseModelWithExtras):
    call_id: str = Field(
        ...,
        description="Identifier so this can be paired with the ExecCommandEnd event.",
    )
    command: list[str] = Field(..., description="The command to be executed.")
    cwd: str = Field(
        ...,
        description="The command's working directory if not the default cwd for the agent.",
    )
    parsed_cmd: list[ParsedCommand]


class ExecCommandOutputDeltaEvent(BaseModelWithExtras):
    call_id: str = Field(
        ..., description="Identifier for the ExecCommandBegin that produced this chunk."
    )
    chunk: str = Field(..., description="Raw bytes from the stream (may not be valid UTF-8).")
    stream: ExecOutputStream = Field(..., description="Which stream produced this chunk.")


class ExecOneOffCommandParams(BaseModelWithExtras):
    command: list[str] = Field(..., description="Command argv to execute.")
    cwd: str | None = Field(
        None,
        description="Optional working directory for the process. Defaults to server config cwd.",
    )
    sandboxPolicy: SandboxPolicy | None = Field(
        None,
        description="Optional explicit sandbox policy overriding the server default.",
    )
    timeoutMs: float | None = Field(
        None,
        description="Timeout of the command in milliseconds. If not specified, a sensible default is used server-side.",
    )


class GetHistoryEntryResponseEvent(BaseModelWithExtras):
    entry: HistoryEntry | None = Field(
        None,
        description="The entry at the requested offset, if available and parseable.",
    )
    log_id: int
    offset: int


class GitDiffToRemoteResponse(BaseModelWithExtras):
    diff: str
    sha: GitSha


class ImageContent(BaseModelWithExtras):
    annotations: Annotations | None = None
    data: str
    mimeType: str
    type: str


class InputItem(RootModel):
    root: InputItemText | InputItemImage | InputItemLocalImage


class InterruptConversationResponse(BaseModelWithExtras):
    abortReason: TurnAbortReason


class LogoutChatGptResponse(RootModel[EmptyObject]):
    root: EmptyObject


class NewConversationParams(BaseModelWithExtras):
    approvalPolicy: AskForApproval | None = Field(
        None,
        description="Approval policy for shell commands generated by the model: `untrusted`, `on-failure`, `on-request`, `never`.",
    )
    baseInstructions: str | None = Field(
        None, description="The set of instructions to use instead of the default ones."
    )
    config: dict[str, JsonValue] | None = Field(
        None,
        description="Individual config settings that will override what is in CODEX_HOME/config.toml.",
    )
    cwd: str | None = Field(
        None,
        description="Working directory for the session. If relative, it is resolved against the server process's current working directory.",
    )
    includeApplyPatchTool: bool | None = Field(
        None, description="Whether to include the apply patch tool in the conversation."
    )
    includePlanTool: bool | None = Field(
        None, description="Whether to include the plan tool in the conversation."
    )
    model: str | None = Field(
        None, description='Optional override for the model name (e.g. "o3", "o4-mini").'
    )
    profile: str | None = Field(
        None,
        description="Configuration profile from config.toml to specify default options.",
    )
    sandbox: SandboxMode | None = Field(
        None,
        description="Sandbox mode: `read-only`, `workspace-write`, or `danger-full-access`.",
    )


class PlanItemArg(BaseModelWithExtras):
    status: StepStatus
    step: str


class Profile(BaseModelWithExtras):
    approvalPolicy: AskForApproval | None = None
    chatgptBaseUrl: str | None = None
    model: str | None = None
    modelProvider: str | None = Field(
        None,
        description="The key in the `model_providers` map identifying the [`ModelProviderInfo`] to use.",
    )
    modelReasoningEffort: ReasoningEffort | None = None
    modelReasoningSummary: ReasoningSummary | None = None
    modelVerbosity: Verbosity | None = None


class RemoveConversationSubscriptionResponse(RootModel[EmptyObject]):
    root: EmptyObject


class ResourceLink(BaseModelWithExtras):
    annotations: Annotations | None = None
    description: str | None = None
    mimeType: str | None = None
    name: str
    size: float | None = None
    title: str | None = None
    type: str
    uri: str


class ResponseItem8(BaseModelWithExtras):
    action: WebSearchAction
    id: str | None = None
    status: str | None = None
    type: Literal["web_search_call"]


class ResponseItem(
    RootModel[
        ResponseItem1
        | ResponseItem2
        | ResponseItem3
        | ResponseItem4
        | ResponseItem5
        | ResponseItem6
        | ResponseItem7
        | ResponseItem8
        | ResponseItem9
    ]
):
    root: (
        ResponseItem1
        | ResponseItem2
        | ResponseItem3
        | ResponseItem4
        | ResponseItem5
        | ResponseItem6
        | ResponseItem7
        | ResponseItem8
        | ResponseItem9
    )


class ResumeConversationParams(BaseModelWithExtras):
    overrides: NewConversationParams | None = Field(
        None,
        description="Optional overrides to apply when spawning the resumed session.",
    )
    path: str = Field(..., description="Absolute path to the rollout JSONL file.")


class SendUserMessageParams(BaseModelWithExtras):
    conversationId: ConversationId
    items: list[InputItem]


class SendUserMessageResponse(RootModel[EmptyObject]):
    root: EmptyObject


class SendUserTurnParams(BaseModelWithExtras):
    approvalPolicy: AskForApproval
    conversationId: ConversationId
    cwd: str
    effort: ReasoningEffort
    items: list[InputItem]
    model: str
    sandboxPolicy: SandboxPolicy
    summary: ReasoningSummary


class SendUserTurnResponse(RootModel[EmptyObject]):
    root: EmptyObject


class ServerCapabilities(BaseModelWithExtras):
    completions: JsonValue | None = None
    experimental: JsonValue | None = None
    logging: JsonValue | None = None
    prompts: ServerCapabilitiesPrompts | None = None
    resources: ServerCapabilitiesResources | None = None
    tools: ServerCapabilitiesTools | None = None


class ServerNotification(RootModel):
    root: ServerNotificationAuthStatusChange | ServerNotificationLoginChatGptComplete


class TextContent(BaseModelWithExtras):
    annotations: Annotations | None = None
    text: str
    type: str


class TokenCountEvent(BaseModelWithExtras):
    info: TokenUsageInfo | None = None


class Tool(BaseModelWithExtras):
    annotations: ToolAnnotations | None = None
    description: str | None = None
    inputSchema: ToolInputSchema
    name: str
    outputSchema: ToolOutputSchema | None = None
    title: str | None = None


class UpdatePlanArgs(BaseModelWithExtras):
    explanation: str | None = None
    plan: list[PlanItemArg]


class UserSavedConfig(BaseModelWithExtras):
    approvalPolicy: AskForApproval | None = Field(None, description="Approvals")
    model: str | None = Field(None, description="Model-specific configuration")
    modelReasoningEffort: ReasoningEffort | None = None
    modelReasoningSummary: ReasoningSummary | None = None
    modelVerbosity: Verbosity | None = None
    profile: str | None = Field(None, description="Profiles")
    profiles: dict[str, Profile]
    sandboxMode: SandboxMode | None = None
    sandboxSettings: SandboxSettings | None = None
    tools: Tools | None = Field(None, description="Tools")


class EventMsgMcpListToolsResponse(BaseModelWithExtras):
    tools: dict[str, Tool] = Field(..., description="Fully qualified tool name -> tool definition.")
    type: Literal["mcp_list_tools_response"]


class EventMsgPlanUpdate(BaseModelWithExtras):
    explanation: str | None = None
    plan: list[PlanItemArg]
    type: Literal["plan_update"]


class EventMsgConversationHistory(BaseModelWithExtras):
    conversation_id: ConversationId
    entries: list[ResponseItem]
    type: Literal["conversation_history"]


class ClientRequestNewConversation(BaseModelWithExtras):
    id: RequestId
    method: Literal["newConversation"]
    params: NewConversationParams


class ClientRequestResumeConversation(BaseModelWithExtras):
    id: RequestId
    method: Literal["resumeConversation"]
    params: ResumeConversationParams


class ClientRequestArchiveConversation(BaseModelWithExtras):
    id: RequestId
    method: Literal["archiveConversation"]
    params: ArchiveConversationParams


class ClientRequestSendUserMessage(BaseModelWithExtras):
    id: RequestId
    method: Literal["sendUserMessage"]
    params: SendUserMessageParams


class ClientRequestSendUserTurn(BaseModelWithExtras):
    id: RequestId
    method: Literal["sendUserTurn"]
    params: SendUserTurnParams


class ClientRequestAddConversationListener(BaseModelWithExtras):
    id: RequestId
    method: Literal["addConversationListener"]
    params: AddConversationListenerParams


class ClientRequestExecOneOffCommand(BaseModelWithExtras):
    id: RequestId
    method: Literal["execOneOffCommand"]
    params: ExecOneOffCommandParams


class ServerRequestApplyPatchApproval(BaseModelWithExtras):
    id: RequestId
    method: Literal["applyPatchApproval"]
    params: ApplyPatchApprovalParams


class ClientRequest(RootModel):
    root: (
        ClientRequestNewConversation
        | ClientRequestListConversations
        | ClientRequestResumeConversation
        | ClientRequestArchiveConversation
        | ClientRequestSendUserMessage
        | ClientRequestSendUserTurn
        | ClientRequestInterruptConversation
        | ClientRequestAddConversationListener
        | ClientRequestRemoveConversationListener
        | ClientRequestGitDiffToRemote
        | ClientRequestLoginChatGpt
        | ClientRequestCancelLoginChatGpt
        | ClientRequestLogoutChatGpt
        | ClientRequestGetAuthStatus
        | ClientRequestGetUserSavedConfig
        | ClientRequestGetUserAgent
        | ClientRequestExecOneOffCommand
    ) = Field(..., description="Request from the client to the server.")


class ConversationHistoryResponseEvent(BaseModelWithExtras):
    conversation_id: ConversationId
    entries: list[ResponseItem]


class EmbeddedResource(BaseModelWithExtras):
    annotations: Annotations | None = None
    resource: EmbeddedResourceResource
    type: str


class GetUserSavedConfigResponse(BaseModelWithExtras):
    config: UserSavedConfig


class InitializeResult(BaseModelWithExtras):
    capabilities: ServerCapabilities
    instructions: str | None = None
    protocolVersion: str
    serverInfo: McpServerInfo


class McpListToolsResponseEvent(BaseModelWithExtras):
    tools: dict[str, Tool] = Field(..., description="Fully qualified tool name -> tool definition.")


class ServerRequest(RootModel):
    root: ServerRequestApplyPatchApproval | ServerRequestExecCommandApproval = Field(
        ..., description="Request initiated from the server and sent to the client."
    )


class ContentBlock(
    RootModel[TextContent | ImageContent | AudioContent | ResourceLink | EmbeddedResource]
):
    root: TextContent | ImageContent | AudioContent | ResourceLink | EmbeddedResource


class CallToolResult(BaseModelWithExtras):
    content: list[ContentBlock]
    isError: bool | None = None
    structuredContent: JsonValue | None = None


class Result(BaseModelWithExtras):
    Ok: CallToolResult


class McpToolCallEndEvent(BaseModelWithExtras):
    call_id: str = Field(
        ...,
        description="Identifier for the corresponding McpToolCallBegin that finished.",
    )
    duration: str | Duration
    invocation: McpInvocation
    result: Result | Result1 = Field(
        ..., description="Result of the tool call. Note this could be an error."
    )


class EventMsgMcpToolCallEnd(BaseModelWithExtras):
    call_id: str = Field(
        ...,
        description="Identifier for the corresponding McpToolCallBegin that finished.",
    )
    duration: str | Duration
    invocation: McpInvocation
    result: Result | Result1 = Field(
        ..., description="Result of the tool call. Note this could be an error."
    )
    type: Literal["mcp_tool_call_end"]


class EventMsg(RootModel):
    root: (
        EventMsgError
        | EventMsgTaskStarted
        | EventMsgTaskComplete
        | EventMsgTokenCount
        | EventMsgAgentMessage
        | EventMsgUserMessage
        | EventMsgAgentMessageDelta
        | EventMsgAgentReasoning
        | EventMsgAgentReasoningDelta
        | EventMsgAgentReasoningRawContent
        | EventMsgAgentReasoningRawContentDelta
        | EventMsgAgentReasoningSectionBreak
        | EventMsgSessionConfigured
        | EventMsgMcpToolCallBegin
        | EventMsgMcpToolCallEnd
        | EventMsgWebSearchBegin
        | EventMsgWebSearchEnd
        | EventMsgExecCommandBegin
        | EventMsgExecCommandOutputDelta
        | EventMsgExecCommandEnd
        | EventMsgExecApprovalRequest
        | EventMsgApplyPatchApprovalRequest
        | EventMsgBackgroundEvent
        | EventMsgStreamError
        | EventMsgPatchApplyBegin
        | EventMsgPatchApplyEnd
        | EventMsgTurnDiff
        | EventMsgGetHistoryEntryResponse
        | EventMsgMcpListToolsResponse
        | EventMsgListCustomPromptsResponse
        | EventMsgPlanUpdate
        | EventMsgTurnAborted
        | EventMsgShutdownComplete
        | EventMsgConversationHistory
    ) = Field(..., description="Response event from the agent")


class ResumeConversationResponse(BaseModelWithExtras):
    conversationId: ConversationId
    initialMessages: list[EventMsg] | None = None
    model: str


class SessionConfiguredEvent(BaseModelWithExtras):
    history_entry_count: int = Field(
        ..., description="Current number of entries in the history log."
    )
    history_log_id: int = Field(
        ...,
        description="Identifier of the history log file (inode on Unix, 0 otherwise).",
    )
    initial_messages: list[EventMsg] | None = Field(
        None,
        description="Optional initial messages (as events) for resumed sessions. When present, UIs can use these to seed the history.",
    )
    model: str = Field(..., description="Tell the client what model is being queried.")
    rollout_path: str
    session_id: ConversationId = Field(
        ...,
        description="Name left as session_id instead of conversation_id for backwards compatibility.",
    )


class EventMsgSessionConfigured(BaseModelWithExtras):
    history_entry_count: int = Field(
        ..., description="Current number of entries in the history log."
    )
    history_log_id: int = Field(
        ...,
        description="Identifier of the history log file (inode on Unix, 0 otherwise).",
    )
    initial_messages: list[EventMsg] | None = Field(
        None,
        description="Optional initial messages (as events) for resumed sessions. When present, UIs can use these to seed the history.",
    )
    model: str = Field(..., description="Tell the client what model is being queried.")
    rollout_path: str
    session_id: ConversationId = Field(
        ...,
        description="Name left as session_id instead of conversation_id for backwards compatibility.",
    )
    type: Literal["session_configured"]


JsonValue.model_rebuild()
EventMsg.model_rebuild()

ClientRequest.model_rebuild()
ServerRequest.model_rebuild()
ServerNotification.model_rebuild()
InputItem.model_rebuild()
