# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from openapi_client.models.list_resource_product_balance import ListResourceProductBalance

from openapi_client.api_client import ApiClient, RequestSerialized
from openapi_client.api_response import ApiResponse
from openapi_client.rest import RESTResponseType


class ReportsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def reports_v1_get_participant_balances(
        self,
        user: Annotated[StrictStr, Field(description='The literal "user" or the UUID of the participant.')],
        client_connection_type: Annotated[
            Optional[List[StrictStr]],
            Field(description="A single ConnectionType of a client connection or a list of ConnectionTypes."),
        ] = None,
        target_client_id: Annotated[
            Optional[List[StrictStr]], Field(description="A single UUID of a target client or a list of UUIDs.")
        ] = None,
        without_attr: Annotated[
            Optional[List[StrictStr]], Field(description="Prevents setting the static data in the balance objects.")
        ] = None,
        product_type: Annotated[
            Optional[List[StrictStr]], Field(description="Filter for a single or list of product types.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResourceProductBalance:
        """List of all balances for a client's own and connected products.


        :param user: The literal \"user\" or the UUID of the participant. (required)
        :type user: str
        :param client_connection_type: A single ConnectionType of a client connection or a list of ConnectionTypes.
        :type client_connection_type: List[str]
        :param target_client_id: A single UUID of a target client or a list of UUIDs.
        :type target_client_id: List[str]
        :param without_attr: Prevents setting the static data in the balance objects.
        :type without_attr: List[str]
        :param product_type: Filter for a single or list of product types.
        :type product_type: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reports_v1_get_participant_balances_serialize(
            user=user,
            client_connection_type=client_connection_type,
            target_client_id=target_client_id,
            without_attr=without_attr,
            product_type=product_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListResourceProductBalance",
            "404": None,
            "422": "StandardErrorResponse",
            "501": None,
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def reports_v1_get_participant_balances_with_http_info(
        self,
        user: Annotated[StrictStr, Field(description='The literal "user" or the UUID of the participant.')],
        client_connection_type: Annotated[
            Optional[List[StrictStr]],
            Field(description="A single ConnectionType of a client connection or a list of ConnectionTypes."),
        ] = None,
        target_client_id: Annotated[
            Optional[List[StrictStr]], Field(description="A single UUID of a target client or a list of UUIDs.")
        ] = None,
        without_attr: Annotated[
            Optional[List[StrictStr]], Field(description="Prevents setting the static data in the balance objects.")
        ] = None,
        product_type: Annotated[
            Optional[List[StrictStr]], Field(description="Filter for a single or list of product types.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResourceProductBalance]:
        """List of all balances for a client's own and connected products.


        :param user: The literal \"user\" or the UUID of the participant. (required)
        :type user: str
        :param client_connection_type: A single ConnectionType of a client connection or a list of ConnectionTypes.
        :type client_connection_type: List[str]
        :param target_client_id: A single UUID of a target client or a list of UUIDs.
        :type target_client_id: List[str]
        :param without_attr: Prevents setting the static data in the balance objects.
        :type without_attr: List[str]
        :param product_type: Filter for a single or list of product types.
        :type product_type: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reports_v1_get_participant_balances_serialize(
            user=user,
            client_connection_type=client_connection_type,
            target_client_id=target_client_id,
            without_attr=without_attr,
            product_type=product_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListResourceProductBalance",
            "404": None,
            "422": "StandardErrorResponse",
            "501": None,
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def reports_v1_get_participant_balances_without_preload_content(
        self,
        user: Annotated[StrictStr, Field(description='The literal "user" or the UUID of the participant.')],
        client_connection_type: Annotated[
            Optional[List[StrictStr]],
            Field(description="A single ConnectionType of a client connection or a list of ConnectionTypes."),
        ] = None,
        target_client_id: Annotated[
            Optional[List[StrictStr]], Field(description="A single UUID of a target client or a list of UUIDs.")
        ] = None,
        without_attr: Annotated[
            Optional[List[StrictStr]], Field(description="Prevents setting the static data in the balance objects.")
        ] = None,
        product_type: Annotated[
            Optional[List[StrictStr]], Field(description="Filter for a single or list of product types.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List of all balances for a client's own and connected products.


        :param user: The literal \"user\" or the UUID of the participant. (required)
        :type user: str
        :param client_connection_type: A single ConnectionType of a client connection or a list of ConnectionTypes.
        :type client_connection_type: List[str]
        :param target_client_id: A single UUID of a target client or a list of UUIDs.
        :type target_client_id: List[str]
        :param without_attr: Prevents setting the static data in the balance objects.
        :type without_attr: List[str]
        :param product_type: Filter for a single or list of product types.
        :type product_type: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reports_v1_get_participant_balances_serialize(
            user=user,
            client_connection_type=client_connection_type,
            target_client_id=target_client_id,
            without_attr=without_attr,
            product_type=product_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListResourceProductBalance",
            "404": None,
            "422": "StandardErrorResponse",
            "501": None,
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _reports_v1_get_participant_balances_serialize(
        self,
        user,
        client_connection_type,
        target_client_id,
        without_attr,
        product_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "clientConnectionType": "multi",
            "targetClientId": "multi",
            "without-attr": "multi",
            "productType": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user is not None:
            _path_params["user"] = user
        # process the query parameters
        if client_connection_type is not None:

            _query_params.append(("clientConnectionType", client_connection_type))

        if target_client_id is not None:

            _query_params.append(("targetClientId", target_client_id))

        if without_attr is not None:

            _query_params.append(("without-attr", without_attr))

        if product_type is not None:

            _query_params.append(("productType", product_type))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/reports/participants/{user}/v1/allbalances",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
