# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.account_information import AccountInformation
from openapi_client.models.amount_value import AmountValue
from openapi_client.models.enum_text import EnumText
from typing import Optional, Set
from typing_extensions import Self


class AccountTransaction(BaseModel):
    """
    Model for an account transaction.
    """  # noqa: E501

    reference: Optional[StrictStr] = Field(default=None, description="unique reference code of the transaction")
    booking_status: Optional[StrictStr] = Field(
        default=None, description="Status of transaction", alias="bookingStatus"
    )
    booking_date: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None, description="ISO-8601 date (YYYY-MM-DD)", alias="bookingDate"
    )
    amount: Optional[AmountValue] = None
    remitter: Optional[AccountInformation] = None
    deptor: Optional[AccountInformation] = None
    creditor: Optional[AccountInformation] = None
    valuta_date: Optional[StrictStr] = Field(
        default=None,
        description="Availability date (yyyy-mm-dd). Could be an invalid date e.g. 2019-12-32",
        alias="valutaDate",
    )
    direct_debit_creditor_id: Optional[StrictStr] = Field(
        default=None,
        description="Gives back the creditor identifier of an account transaction, if it is a direct debit.",
        alias="directDebitCreditorId",
    )
    direct_debit_mandate_id: Optional[StrictStr] = Field(
        default=None,
        description="Gives back the mandateId of an account transaction, if it is a direct debit.",
        alias="directDebitMandateId",
    )
    end_to_end_reference: Optional[StrictStr] = Field(
        default=None,
        description="Gives back the end-to-end-reference of an account transaction, if it is a direct debit.",
        alias="endToEndReference",
    )
    new_transaction: Optional[StrictBool] = Field(
        default=False,
        description="Shows whether the client has seen the account transaction in web.",
        alias="newTransaction",
    )
    remittance_info: Optional[StrictStr] = Field(
        default=None,
        description="remittance information of the transaction. This can be more then one line with a length of 35 symbols. The lines will be numbered in case of an already booked transaction.",
        alias="remittanceInfo",
    )
    transaction_type: Optional[EnumText] = Field(default=None, alias="transactionType")
    __properties: ClassVar[List[str]] = [
        "reference",
        "bookingStatus",
        "bookingDate",
        "amount",
        "remitter",
        "deptor",
        "creditor",
        "valutaDate",
        "directDebitCreditorId",
        "directDebitMandateId",
        "endToEndReference",
        "newTransaction",
        "remittanceInfo",
        "transactionType",
    ]

    @field_validator("booking_status")
    def booking_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["BOOKED", "NOTBOOKED"]):
            raise ValueError("must be one of enum values ('BOOKED', 'NOTBOOKED')")
        return value

    @field_validator("booking_date")
    def booking_date_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{4}-\d{2}-\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccountTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "reference",
                "booking_status",
                "valuta_date",
                "direct_debit_creditor_id",
                "direct_debit_mandate_id",
                "end_to_end_reference",
                "new_transaction",
                "remittance_info",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of amount
        if self.amount:
            _dict["amount"] = self.amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of remitter
        if self.remitter:
            _dict["remitter"] = self.remitter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of deptor
        if self.deptor:
            _dict["deptor"] = self.deptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of creditor
        if self.creditor:
            _dict["creditor"] = self.creditor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transaction_type
        if self.transaction_type:
            _dict["transactionType"] = self.transaction_type.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccountTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "reference": obj.get("reference"),
                "bookingStatus": obj.get("bookingStatus"),
                "bookingDate": obj.get("bookingDate"),
                "amount": AmountValue.from_dict(obj["amount"]) if obj.get("amount") is not None else None,
                "remitter": AccountInformation.from_dict(obj["remitter"]) if obj.get("remitter") is not None else None,
                "deptor": AccountInformation.from_dict(obj["deptor"]) if obj.get("deptor") is not None else None,
                "creditor": AccountInformation.from_dict(obj["creditor"]) if obj.get("creditor") is not None else None,
                "valutaDate": obj.get("valutaDate"),
                "directDebitCreditorId": obj.get("directDebitCreditorId"),
                "directDebitMandateId": obj.get("directDebitMandateId"),
                "endToEndReference": obj.get("endToEndReference"),
                "newTransaction": obj.get("newTransaction") if obj.get("newTransaction") is not None else False,
                "remittanceInfo": obj.get("remittanceInfo"),
                "transactionType": (
                    EnumText.from_dict(obj["transactionType"]) if obj.get("transactionType") is not None else None
                ),
            }
        )
        return _obj
