# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class Depot(BaseModel):
    """
    Depot
    """  # noqa: E501

    depot_id: Optional[StrictStr] = Field(
        default=None, description="Securities account Identifier (UUID)", alias="depotId"
    )
    depot_display_id: Optional[StrictStr] = Field(
        default=None, description="Securities account Number", alias="depotDisplayId"
    )
    client_id: Optional[StrictStr] = Field(
        default=None,
        description="Identification code of the client uniquely assigned to the securities account",
        alias="clientId",
    )
    default_settlement_account_id: Optional[StrictStr] = Field(
        default=None,
        description="Default settlement account number uniquely assigned to the securities account",
        alias="defaultSettlementAccountId",
    )
    settlement_account_ids: Optional[List[StrictStr]] = Field(
        default=None,
        description="List of other settlement account identification numbers assigned to the securities account",
        alias="settlementAccountIds",
    )
    __properties: ClassVar[List[str]] = [
        "depotId",
        "depotDisplayId",
        "clientId",
        "defaultSettlementAccountId",
        "settlementAccountIds",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Depot from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "depot_id",
                "depot_display_id",
                "client_id",
                "default_settlement_account_id",
                "settlement_account_ids",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Depot from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "depotId": obj.get("depotId"),
                "depotDisplayId": obj.get("depotDisplayId"),
                "clientId": obj.get("clientId"),
                "defaultSettlementAccountId": obj.get("defaultSettlementAccountId"),
                "settlementAccountIds": obj.get("settlementAccountIds"),
            }
        )
        return _obj
