# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.amount_value import AmountValue
from openapi_client.models.fx_rate_eur import FXRateEUR
from openapi_client.models.instrument import Instrument
from typing import Optional, Set
from typing_extensions import Self


class DepotTransaction(BaseModel):
    """
    Model for a depot transaction.
    """  # noqa: E501

    transaction_id: Optional[StrictStr] = Field(
        default=None, description="Transaction Identifier (UUID)", alias="transactionId"
    )
    booking_status: Optional[StrictStr] = Field(
        default=None, description="Status of transaction", alias="bookingStatus"
    )
    booking_date: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None, description="ISO-8601 date (YYYY-MM-DD)", alias="bookingDate"
    )
    settlement_date: Optional[StrictStr] = Field(
        default=None, description="ISO-8601 date-time (YYYY-MM-DDThh:mm:ssZ)", alias="settlementDate"
    )
    business_date: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None, description="ISO-8601 date (YYYY-MM-DD)", alias="businessDate"
    )
    quantity: Optional[AmountValue] = None
    instrument_id: Optional[StrictStr] = Field(default=None, description="InstrumentId as UUID", alias="instrumentId")
    instrument: Optional[Instrument] = None
    execution_price: Optional[AmountValue] = Field(default=None, alias="executionPrice")
    transaction_value: Optional[AmountValue] = Field(default=None, alias="transactionValue")
    transaction_direction: Optional[StrictStr] = Field(
        default=None, description="Transaction direction", alias="transactionDirection"
    )
    transaction_type: Optional[StrictStr] = Field(
        default=None,
        description="On the basis of securities account turnover transaction type",
        alias="transactionType",
    )
    fx_rate: Optional[FXRateEUR] = Field(default=None, alias="fxRate")
    __properties: ClassVar[List[str]] = [
        "transactionId",
        "bookingStatus",
        "bookingDate",
        "settlementDate",
        "businessDate",
        "quantity",
        "instrumentId",
        "instrument",
        "executionPrice",
        "transactionValue",
        "transactionDirection",
        "transactionType",
        "fxRate",
    ]

    @field_validator("booking_status")
    def booking_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["BOOKED", "NOTBOOKED"]):
            raise ValueError("must be one of enum values ('BOOKED', 'NOTBOOKED')")
        return value

    @field_validator("booking_date")
    def booking_date_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{4}-\d{2}-\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}$/")
        return value

    @field_validator("business_date")
    def business_date_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{4}-\d{2}-\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}$/")
        return value

    @field_validator("transaction_direction")
    def transaction_direction_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["IN", "OUT"]):
            raise ValueError("must be one of enum values ('IN', 'OUT')")
        return value

    @field_validator("transaction_type")
    def transaction_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["BUY", "SELL", "TRANSFER_IN", "TRANSFER_OUT", "OTHER"]):
            raise ValueError("must be one of enum values ('BUY', 'SELL', 'TRANSFER_IN', 'TRANSFER_OUT', 'OTHER')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DepotTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "transaction_id",
                "booking_status",
                "instrument_id",
                "transaction_direction",
                "transaction_type",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of quantity
        if self.quantity:
            _dict["quantity"] = self.quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instrument
        if self.instrument:
            _dict["instrument"] = self.instrument.to_dict()
        # override the default output from pydantic by calling `to_dict()` of execution_price
        if self.execution_price:
            _dict["executionPrice"] = self.execution_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transaction_value
        if self.transaction_value:
            _dict["transactionValue"] = self.transaction_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fx_rate
        if self.fx_rate:
            _dict["fxRate"] = self.fx_rate.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DepotTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "transactionId": obj.get("transactionId"),
                "bookingStatus": obj.get("bookingStatus"),
                "bookingDate": obj.get("bookingDate"),
                "settlementDate": obj.get("settlementDate"),
                "businessDate": obj.get("businessDate"),
                "quantity": AmountValue.from_dict(obj["quantity"]) if obj.get("quantity") is not None else None,
                "instrumentId": obj.get("instrumentId"),
                "instrument": Instrument.from_dict(obj["instrument"]) if obj.get("instrument") is not None else None,
                "executionPrice": (
                    AmountValue.from_dict(obj["executionPrice"]) if obj.get("executionPrice") is not None else None
                ),
                "transactionValue": (
                    AmountValue.from_dict(obj["transactionValue"]) if obj.get("transactionValue") is not None else None
                ),
                "transactionDirection": obj.get("transactionDirection"),
                "transactionType": obj.get("transactionType"),
                "fxRate": FXRateEUR.from_dict(obj["fxRate"]) if obj.get("fxRate") is not None else None,
            }
        )
        return _obj
