# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.amount_value import AmountValue
from openapi_client.models.price import Price
from openapi_client.models.rating import Rating
from typing import Optional, Set
from typing_extensions import Self


class DerivativeData(BaseModel):
    """
    additional data of a derivative
    """  # noqa: E501

    underlying_instrument: Optional[Instrument] = Field(default=None, alias="underlyingInstrument")
    underlying_price: Optional[Price] = Field(default=None, alias="underlyingPrice")
    certificate_type: Optional[StrictStr] = Field(
        default=None, description="Certificate Type", alias="certificateType"
    )
    rating: Optional[Rating] = None
    strike_price: Optional[AmountValue] = Field(default=None, alias="strikePrice")
    leverage: Optional[StrictStr] = Field(default=None, description="Leverage of the derivate")
    multiplier: Optional[StrictStr] = Field(default=None, description="multiplier of the underlying")
    expiry_date: Optional[StrictStr] = Field(
        default=None, description="expiry date of a derivative", alias="expiryDate"
    )
    yield_pa: Optional[StrictStr] = Field(default=None, description="yield p.a.", alias="yieldPA")
    remaining_term_in_years: Optional[StrictStr] = Field(
        default=None, description="remaining Term (expiryDate-today)", alias="remainingTermInYears"
    )
    nominal_rate: Optional[StrictStr] = Field(default=None, description="nominal rate", alias="nominalRate")
    warrant_type: Optional[StrictStr] = Field(default=None, description="Warrant Type", alias="warrantType")
    maturity_date: Optional[StrictStr] = Field(
        default=None, description="maturity Date of a bonds", alias="maturityDate"
    )
    interest_payment_date: Optional[StrictStr] = Field(
        default=None, description="date of the interest payment of a bond", alias="interestPaymentDate"
    )
    interest_payment_interval: Optional[StrictStr] = Field(
        default=None,
        description='interval of the interest payment of a bond",allowableValues = "monthly, quarterly, biannualy, annualy',
        alias="interestPaymentInterval",
    )
    __properties: ClassVar[List[str]] = [
        "underlyingInstrument",
        "underlyingPrice",
        "certificateType",
        "rating",
        "strikePrice",
        "leverage",
        "multiplier",
        "expiryDate",
        "yieldPA",
        "remainingTermInYears",
        "nominalRate",
        "warrantType",
        "maturityDate",
        "interestPaymentDate",
        "interestPaymentInterval",
    ]

    @field_validator("certificate_type")
    def certificate_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            [
                "Hebel",
                "Index",
                "Basket",
                "Hedge-Fonds-Zertifikat",
                "Discount",
                "Aktienanleihe",
                "Bandbreite",
                "Outperformance",
                "Express",
                "Bonus",
                "Kapitalschutz",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('Hebel', 'Index', 'Basket', 'Hedge-Fonds-Zertifikat', 'Discount', 'Aktienanleihe', 'Bandbreite', 'Outperformance', 'Express', 'Bonus', 'Kapitalschutz')"
            )
        return value

    @field_validator("warrant_type")
    def warrant_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["Call", "Put"]):
            raise ValueError("must be one of enum values ('Call', 'Put')")
        return value

    @field_validator("interest_payment_interval")
    def interest_payment_interval_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["MONTHLY", "QUARTERLY", "SEMIANNUALLY", "ANNUALLY", "OTHER"]):
            raise ValueError(
                "must be one of enum values ('MONTHLY', 'QUARTERLY', 'SEMIANNUALLY', 'ANNUALLY', 'OTHER')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DerivativeData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "certificate_type",
                "leverage",
                "multiplier",
                "expiry_date",
                "yield_pa",
                "remaining_term_in_years",
                "nominal_rate",
                "warrant_type",
                "maturity_date",
                "interest_payment_date",
                "interest_payment_interval",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of underlying_instrument
        if self.underlying_instrument:
            _dict["underlyingInstrument"] = self.underlying_instrument.to_dict()
        # override the default output from pydantic by calling `to_dict()` of underlying_price
        if self.underlying_price:
            _dict["underlyingPrice"] = self.underlying_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rating
        if self.rating:
            _dict["rating"] = self.rating.to_dict()
        # override the default output from pydantic by calling `to_dict()` of strike_price
        if self.strike_price:
            _dict["strikePrice"] = self.strike_price.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DerivativeData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "underlyingInstrument": (
                    Instrument.from_dict(obj["underlyingInstrument"])
                    if obj.get("underlyingInstrument") is not None
                    else None
                ),
                "underlyingPrice": (
                    Price.from_dict(obj["underlyingPrice"]) if obj.get("underlyingPrice") is not None else None
                ),
                "certificateType": obj.get("certificateType"),
                "rating": Rating.from_dict(obj["rating"]) if obj.get("rating") is not None else None,
                "strikePrice": (
                    AmountValue.from_dict(obj["strikePrice"]) if obj.get("strikePrice") is not None else None
                ),
                "leverage": obj.get("leverage"),
                "multiplier": obj.get("multiplier"),
                "expiryDate": obj.get("expiryDate"),
                "yieldPA": obj.get("yieldPA"),
                "remainingTermInYears": obj.get("remainingTermInYears"),
                "nominalRate": obj.get("nominalRate"),
                "warrantType": obj.get("warrantType"),
                "maturityDate": obj.get("maturityDate"),
                "interestPaymentDate": obj.get("interestPaymentDate"),
                "interestPaymentInterval": obj.get("interestPaymentInterval"),
            }
        )
        return _obj


from openapi_client.models.instrument import Instrument

# TODO: Rewrite to not use raise_errors
DerivativeData.model_rebuild(raise_errors=False)
