# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.amount_value import AmountValue
from typing import Optional, Set
from typing_extensions import Self


class FixedTermSavings(BaseModel):
    """
    FixedTermSavings
    """  # noqa: E501

    fixed_term_savings_id: Optional[StrictStr] = Field(
        default=None, description="UUID of the deposit account.", alias="fixedTermSavingsId"
    )
    savings_amount: Optional[AmountValue] = Field(default=None, alias="savingsAmount")
    interest_rate: Optional[StrictStr] = Field(
        default=None, description="Interest rate of the deposit account.", alias="interestRate"
    )
    fixed_term_savings_type: Optional[StrictStr] = Field(
        default=None, description="Type of the deposit account.", alias="fixedTermSavingsType"
    )
    fixed_term_savings_display_name: Optional[StrictStr] = Field(
        default=None, description="Name of the deposit account.", alias="fixedTermSavingsDisplayName"
    )
    contract_period_in_months: Optional[StrictInt] = Field(
        default=None, description="Contract period of the deposit account in months.", alias="contractPeriodInMonths"
    )
    creation_date: Optional[StrictStr] = Field(
        default=None, description="Start date of investment.", alias="creationDate"
    )
    expiration_date: Optional[StrictStr] = Field(
        default=None, description="End date of investment.", alias="expirationDate"
    )
    prolongation_amount: Optional[AmountValue] = Field(default=None, alias="prolongationAmount")
    extendable: Optional[StrictBool] = Field(
        default=False, description="Indicates whether the investment can be extended."
    )
    __properties: ClassVar[List[str]] = [
        "fixedTermSavingsId",
        "savingsAmount",
        "interestRate",
        "fixedTermSavingsType",
        "fixedTermSavingsDisplayName",
        "contractPeriodInMonths",
        "creationDate",
        "expirationDate",
        "prolongationAmount",
        "extendable",
    ]

    @field_validator("fixed_term_savings_type")
    def fixed_term_savings_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["SHORT_TERM", "LONG_TERM"]):
            raise ValueError("must be one of enum values ('SHORT_TERM', 'LONG_TERM')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FixedTermSavings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "fixed_term_savings_id",
                "interest_rate",
                "fixed_term_savings_type",
                "fixed_term_savings_display_name",
                "contract_period_in_months",
                "creation_date",
                "expiration_date",
                "extendable",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of savings_amount
        if self.savings_amount:
            _dict["savingsAmount"] = self.savings_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of prolongation_amount
        if self.prolongation_amount:
            _dict["prolongationAmount"] = self.prolongation_amount.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FixedTermSavings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "fixedTermSavingsId": obj.get("fixedTermSavingsId"),
                "savingsAmount": (
                    AmountValue.from_dict(obj["savingsAmount"]) if obj.get("savingsAmount") is not None else None
                ),
                "interestRate": obj.get("interestRate"),
                "fixedTermSavingsType": obj.get("fixedTermSavingsType"),
                "fixedTermSavingsDisplayName": obj.get("fixedTermSavingsDisplayName"),
                "contractPeriodInMonths": obj.get("contractPeriodInMonths"),
                "creationDate": obj.get("creationDate"),
                "expirationDate": obj.get("expirationDate"),
                "prolongationAmount": (
                    AmountValue.from_dict(obj["prolongationAmount"])
                    if obj.get("prolongationAmount") is not None
                    else None
                ),
                "extendable": obj.get("extendable") if obj.get("extendable") is not None else False,
            }
        )
        return _obj
