# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.rating import Rating
from typing import Optional, Set
from typing_extensions import Self


class FundDistribution(BaseModel):
    """
    additional fund data, if the instrument is a fund
    """  # noqa: E501

    fund_status: Optional[StrictStr] = Field(default=None, description="Status of fund", alias="fundStatus")
    fund_flags: Optional[List[StrictStr]] = Field(
        default=None, description="List of different features of funds", alias="fundFlags"
    )
    currency: Optional[StrictStr] = Field(default=None, description="currency of fund")
    regular_issue_surcharge: Optional[StrictStr] = Field(
        default=None, description="Regular issue surcharge", alias="regularIssueSurcharge"
    )
    discount_issue_surcharge: Optional[StrictStr] = Field(
        default=None, description="Discount issue surcharge", alias="discountIssueSurcharge"
    )
    reduced_issue_surcharge: Optional[StrictStr] = Field(
        default=None, description="Reduced issue surcharge", alias="reducedIssueSurcharge"
    )
    individual_issue_surcharge: Optional[StrictStr] = Field(
        default=None, description="Individual issue surcharge", alias="individualIssueSurcharge"
    )
    is_individual_issue_surcharge_corrected: Optional[StrictBool] = Field(
        default=False,
        description="Is individual issue surcharge corrected",
        alias="isIndividualIssueSurchargeCorrected",
    )
    bonification: Optional[StrictStr] = Field(default=None, description="Bonification")
    investment_category: Optional[StrictStr] = Field(
        default=None, description="Investment category", alias="investmentCategory"
    )
    total_expense_ratio: Optional[StrictStr] = Field(
        default=None, description="Total expense ratio", alias="totalExpenseRatio"
    )
    rating: Optional[Rating] = None
    __properties: ClassVar[List[str]] = [
        "fundStatus",
        "fundFlags",
        "currency",
        "regularIssueSurcharge",
        "discountIssueSurcharge",
        "reducedIssueSurcharge",
        "individualIssueSurcharge",
        "isIndividualIssueSurchargeCorrected",
        "bonification",
        "investmentCategory",
        "totalExpenseRatio",
        "rating",
    ]

    @field_validator("fund_status")
    def fund_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["A", "K", "P", "R", "V", "N", "L", "D", "F", "I", "M"]):
            raise ValueError("must be one of enum values ('A', 'K', 'P', 'R', 'V', 'N', 'L', 'D', 'F', 'I', 'M')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FundDistribution from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "fund_status",
                "fund_flags",
                "currency",
                "regular_issue_surcharge",
                "discount_issue_surcharge",
                "reduced_issue_surcharge",
                "individual_issue_surcharge",
                "is_individual_issue_surcharge_corrected",
                "bonification",
                "investment_category",
                "total_expense_ratio",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rating
        if self.rating:
            _dict["rating"] = self.rating.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FundDistribution from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "fundStatus": obj.get("fundStatus"),
                "fundFlags": obj.get("fundFlags"),
                "currency": obj.get("currency"),
                "regularIssueSurcharge": obj.get("regularIssueSurcharge"),
                "discountIssueSurcharge": obj.get("discountIssueSurcharge"),
                "reducedIssueSurcharge": obj.get("reducedIssueSurcharge"),
                "individualIssueSurcharge": obj.get("individualIssueSurcharge"),
                "isIndividualIssueSurchargeCorrected": (
                    obj.get("isIndividualIssueSurchargeCorrected")
                    if obj.get("isIndividualIssueSurchargeCorrected") is not None
                    else False
                ),
                "bonification": obj.get("bonification"),
                "investmentCategory": obj.get("investmentCategory"),
                "totalExpenseRatio": obj.get("totalExpenseRatio"),
                "rating": Rating.from_dict(obj["rating"]) if obj.get("rating") is not None else None,
            }
        )
        return _obj
