# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.total_holding_cost_entry import TotalHoldingCostEntry
from typing import Optional, Set
from typing_extensions import Self


class TotalHoldingCostBlock(BaseModel):
    """
    List of cost blocks over time.
    """  # noqa: E501

    year1: Optional[TotalHoldingCostEntry] = None
    year2: Optional[TotalHoldingCostEntry] = None
    sales: Optional[TotalHoldingCostEntry] = None
    __properties: ClassVar[List[str]] = ["year1", "year2", "sales"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TotalHoldingCostBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of year1
        if self.year1:
            _dict["year1"] = self.year1.to_dict()
        # override the default output from pydantic by calling `to_dict()` of year2
        if self.year2:
            _dict["year2"] = self.year2.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sales
        if self.sales:
            _dict["sales"] = self.sales.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TotalHoldingCostBlock from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "year1": TotalHoldingCostEntry.from_dict(obj["year1"]) if obj.get("year1") is not None else None,
                "year2": TotalHoldingCostEntry.from_dict(obj["year2"]) if obj.get("year2") is not None else None,
                "sales": TotalHoldingCostEntry.from_dict(obj["sales"]) if obj.get("sales") is not None else None,
            }
        )
        return _obj
