# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.amount_value import AmountValue
from openapi_client.models.enum_text import EnumText
from typing import Optional, Set
from typing_extensions import Self


class Account(BaseModel):
    """
    Master data of an account
    """  # noqa: E501

    account_id: Optional[StrictStr] = Field(default=None, description="Account identifier (UUID)", alias="accountId")
    account_display_id: Optional[StrictStr] = Field(
        default=None, description="Account identfier", alias="accountDisplayId"
    )
    currency: Optional[StrictStr] = Field(default=None, description="ISO-4217 currency code")
    client_id: Optional[StrictStr] = Field(
        default=None, description="Identification Code of the client (UUID)", alias="clientId"
    )
    account_type: Optional[EnumText] = Field(default=None, alias="accountType")
    iban: Optional[StrictStr] = Field(
        default=None, description="IBAN (International bank account number), if available"
    )
    credit_limit: Optional[AmountValue] = Field(default=None, alias="creditLimit")
    __properties: ClassVar[List[str]] = [
        "accountId",
        "accountDisplayId",
        "currency",
        "clientId",
        "accountType",
        "iban",
        "creditLimit",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Account from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "account_id",
                "account_display_id",
                "client_id",
                "iban",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account_type
        if self.account_type:
            _dict["accountType"] = self.account_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credit_limit
        if self.credit_limit:
            _dict["creditLimit"] = self.credit_limit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Account from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "accountId": obj.get("accountId"),
                "accountDisplayId": obj.get("accountDisplayId"),
                "currency": obj.get("currency"),
                "clientId": obj.get("clientId"),
                "accountType": EnumText.from_dict(obj["accountType"]) if obj.get("accountType") is not None else None,
                "iban": obj.get("iban"),
                "creditLimit": (
                    AmountValue.from_dict(obj["creditLimit"]) if obj.get("creditLimit") is not None else None
                ),
            }
        )
        return _obj
