# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.account import Account
from openapi_client.models.amount_value import AmountValue
from typing import Optional, Set
from typing_extensions import Self


class AccountBalance(BaseModel):
    """
    Account information, including cash balance and buying power
    """  # noqa: E501

    account: Optional[Account] = None
    account_id: Optional[StrictStr] = Field(default=None, description="Account identifier (UUID)", alias="accountId")
    balance: Optional[AmountValue] = None
    balance_eur: Optional[AmountValue] = Field(default=None, alias="balanceEUR")
    available_cash_amount: Optional[AmountValue] = Field(default=None, alias="availableCashAmount")
    available_cash_amount_eur: Optional[AmountValue] = Field(default=None, alias="availableCashAmountEUR")
    __properties: ClassVar[List[str]] = [
        "account",
        "accountId",
        "balance",
        "balanceEUR",
        "availableCashAmount",
        "availableCashAmountEUR",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccountBalance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "account_id",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict["account"] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of balance
        if self.balance:
            _dict["balance"] = self.balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of balance_eur
        if self.balance_eur:
            _dict["balanceEUR"] = self.balance_eur.to_dict()
        # override the default output from pydantic by calling `to_dict()` of available_cash_amount
        if self.available_cash_amount:
            _dict["availableCashAmount"] = self.available_cash_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of available_cash_amount_eur
        if self.available_cash_amount_eur:
            _dict["availableCashAmountEUR"] = self.available_cash_amount_eur.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccountBalance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "account": Account.from_dict(obj["account"]) if obj.get("account") is not None else None,
                "accountId": obj.get("accountId"),
                "balance": AmountValue.from_dict(obj["balance"]) if obj.get("balance") is not None else None,
                "balanceEUR": AmountValue.from_dict(obj["balanceEUR"]) if obj.get("balanceEUR") is not None else None,
                "availableCashAmount": (
                    AmountValue.from_dict(obj["availableCashAmount"])
                    if obj.get("availableCashAmount") is not None
                    else None
                ),
                "availableCashAmountEUR": (
                    AmountValue.from_dict(obj["availableCashAmountEUR"])
                    if obj.get("availableCashAmountEUR") is not None
                    else None
                ),
            }
        )
        return _obj
