# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.account_balance import AccountBalance
from openapi_client.models.card_balance import CardBalance
from openapi_client.models.depot_aggregation import DepotAggregation
from openapi_client.models.fixed_term_savings import FixedTermSavings
from openapi_client.models.installment_loan_balance import InstallmentLoanBalance
from typing import Optional, Set
from typing_extensions import Self


class Balance(BaseModel):
    """
    A balance object is equal to one of the types indicated by the attributes in this definition.
    """  # noqa: E501

    account_balance: Optional[AccountBalance] = Field(default=None, alias="accountBalance")
    card_balance: Optional[CardBalance] = Field(default=None, alias="cardBalance")
    depot_aggregation: Optional[DepotAggregation] = Field(default=None, alias="depotAggregation")
    fixed_term_savings: Optional[FixedTermSavings] = Field(default=None, alias="fixedTermSavings")
    installment_loan_balance: Optional[InstallmentLoanBalance] = Field(default=None, alias="installmentLoanBalance")
    __properties: ClassVar[List[str]] = [
        "accountBalance",
        "cardBalance",
        "depotAggregation",
        "fixedTermSavings",
        "installmentLoanBalance",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Balance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account_balance
        if self.account_balance:
            _dict["accountBalance"] = self.account_balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of card_balance
        if self.card_balance:
            _dict["cardBalance"] = self.card_balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of depot_aggregation
        if self.depot_aggregation:
            _dict["depotAggregation"] = self.depot_aggregation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fixed_term_savings
        if self.fixed_term_savings:
            _dict["fixedTermSavings"] = self.fixed_term_savings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of installment_loan_balance
        if self.installment_loan_balance:
            _dict["installmentLoanBalance"] = self.installment_loan_balance.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Balance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "accountBalance": (
                    AccountBalance.from_dict(obj["accountBalance"]) if obj.get("accountBalance") is not None else None
                ),
                "cardBalance": (
                    CardBalance.from_dict(obj["cardBalance"]) if obj.get("cardBalance") is not None else None
                ),
                "depotAggregation": (
                    DepotAggregation.from_dict(obj["depotAggregation"])
                    if obj.get("depotAggregation") is not None
                    else None
                ),
                "fixedTermSavings": (
                    FixedTermSavings.from_dict(obj["fixedTermSavings"])
                    if obj.get("fixedTermSavings") is not None
                    else None
                ),
                "installmentLoanBalance": (
                    InstallmentLoanBalance.from_dict(obj["installmentLoanBalance"])
                    if obj.get("installmentLoanBalance") is not None
                    else None
                ),
            }
        )
        return _obj
