# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class BusinessMessage(BaseModel):
    """
    Model for an error
    """  # noqa: E501

    key: Optional[StrictStr] = Field(default=None, description="Identifier for the error")
    severity: Optional[StrictStr] = Field(default=None, description="Severity level of the error")
    message: Optional[StrictStr] = Field(default=None, description="Default error message")
    origin: Optional[List[StrictStr]] = Field(default=None, description="List of properties causing validation errors")
    args: Optional[List[Dict[str, Any]]] = Field(default=None, description="Arguments for the error message")
    __properties: ClassVar[List[str]] = ["key", "severity", "message", "origin", "args"]

    @field_validator("key")
    def key_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["request.object.invalid", "request.query.invalid"]):
            raise ValueError("must be one of enum values ('request.object.invalid', 'request.query.invalid')")
        return value

    @field_validator("severity")
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["ERROR", "INFO", "WARN"]):
            raise ValueError("must be one of enum values ('ERROR', 'INFO', 'WARN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BusinessMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BusinessMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "key": obj.get("key"),
                "severity": obj.get("severity"),
                "message": obj.get("message"),
                "origin": obj.get("origin"),
                "args": obj.get("args"),
            }
        )
        return _obj
