# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.amount_value import AmountValue
from openapi_client.models.enum_text import EnumText
from openapi_client.models.visa_card_image import VisaCardImage
from typing import Optional, Set
from typing_extensions import Self


class Card(BaseModel):
    """
    Model for a card.
    """  # noqa: E501

    card_id: Optional[StrictStr] = Field(default=None, description="Card identifier (UUID).", alias="cardId")
    card_type: Optional[EnumText] = Field(default=None, alias="cardType")
    client_id: Optional[StrictStr] = Field(
        default=None, description="Client connection uniquely assigned to the credit card account.", alias="clientId"
    )
    participant_id: Optional[StrictStr] = Field(
        default=None,
        description="Contract code of the client uniquely assigned to the credit card account.",
        alias="participantId",
    )
    holder_name: Optional[StrictStr] = Field(default=None, description="Name of the card holder", alias="holderName")
    settlement_account_id: Optional[StrictStr] = Field(
        default=None,
        description="Default settlement account number uniquely assigned to the credit card account. In this case, it has to be the current account.",
        alias="settlementAccountId",
    )
    card_display_id: Optional[StrictStr] = Field(
        default=None, description="Partially masked credit card number.", alias="cardDisplayId"
    )
    card_validity: Optional[StrictStr] = Field(
        default=None, description="validity of the card. Format: MM/YY", alias="cardValidity"
    )
    card_image: Optional[VisaCardImage] = Field(default=None, alias="cardImage")
    primary_account_number_suffix: Optional[StrictStr] = Field(
        default=None, description="Last 4 digits of the credit card number", alias="primaryAccountNumberSuffix"
    )
    card_limit: Optional[AmountValue] = Field(default=None, alias="cardLimit")
    status: Optional[StrictStr] = Field(default=None, description="Status of the card.")
    __properties: ClassVar[List[str]] = [
        "cardId",
        "cardType",
        "clientId",
        "participantId",
        "holderName",
        "settlementAccountId",
        "cardDisplayId",
        "cardValidity",
        "cardImage",
        "primaryAccountNumberSuffix",
        "cardLimit",
        "status",
    ]

    @field_validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["ACTIVE", "INACTIVE", "IN_CHANGE", "UNKNOWN"]):
            raise ValueError("must be one of enum values ('ACTIVE', 'INACTIVE', 'IN_CHANGE', 'UNKNOWN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Card from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "card_id",
                "client_id",
                "participant_id",
                "holder_name",
                "settlement_account_id",
                "card_display_id",
                "card_validity",
                "primary_account_number_suffix",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of card_type
        if self.card_type:
            _dict["cardType"] = self.card_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of card_image
        if self.card_image:
            _dict["cardImage"] = self.card_image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of card_limit
        if self.card_limit:
            _dict["cardLimit"] = self.card_limit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Card from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "cardId": obj.get("cardId"),
                "cardType": EnumText.from_dict(obj["cardType"]) if obj.get("cardType") is not None else None,
                "clientId": obj.get("clientId"),
                "participantId": obj.get("participantId"),
                "holderName": obj.get("holderName"),
                "settlementAccountId": obj.get("settlementAccountId"),
                "cardDisplayId": obj.get("cardDisplayId"),
                "cardValidity": obj.get("cardValidity"),
                "cardImage": VisaCardImage.from_dict(obj["cardImage"]) if obj.get("cardImage") is not None else None,
                "primaryAccountNumberSuffix": obj.get("primaryAccountNumberSuffix"),
                "cardLimit": AmountValue.from_dict(obj["cardLimit"]) if obj.get("cardLimit") is not None else None,
                "status": obj.get("status"),
            }
        )
        return _obj
