# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.amount_value import AmountValue
from openapi_client.models.cost_entry import CostEntry
from typing import Optional, Set
from typing_extensions import Self


class CostGroup(BaseModel):
    """
    Model for a cost group including a list of cost entries for this cost group.
    """  # noqa: E501

    type: Optional[StrictStr] = Field(
        default=None,
        description="Type of cost group. K: Costs of securities purchase, H: Costs of the holding period (per year), V: Costs of the sale of securities",
    )
    label: Optional[StrictStr] = Field(default=None, description="Name of cost group for showing in the cost-note")
    sum: Optional[AmountValue] = None
    sum_reporting_currency: Optional[AmountValue] = Field(default=None, alias="sumReportingCurrency")
    costs: Optional[List[CostEntry]] = Field(default=None, description="List of costs per cost group")
    __properties: ClassVar[List[str]] = ["type", "label", "sum", "sumReportingCurrency", "costs"]

    @field_validator("type")
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["K", "H", "V"]):
            raise ValueError("must be one of enum values ('K', 'H', 'V')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CostGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "type",
                "label",
                "costs",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of sum
        if self.sum:
            _dict["sum"] = self.sum.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sum_reporting_currency
        if self.sum_reporting_currency:
            _dict["sumReportingCurrency"] = self.sum_reporting_currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in costs (list)
        _items = []
        if self.costs:
            for _item_costs in self.costs:
                if _item_costs:
                    _items.append(_item_costs.to_dict())
            _dict["costs"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CostGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "label": obj.get("label"),
                "sum": AmountValue.from_dict(obj["sum"]) if obj.get("sum") is not None else None,
                "sumReportingCurrency": (
                    AmountValue.from_dict(obj["sumReportingCurrency"])
                    if obj.get("sumReportingCurrency") is not None
                    else None
                ),
                "costs": (
                    [CostEntry.from_dict(_item) for _item in obj["costs"]] if obj.get("costs") is not None else None
                ),
            }
        )
        return _obj
