# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.amount_value import AmountValue
from openapi_client.models.cost_group import CostGroup
from openapi_client.models.fx_rate_eur import FXRateEUR
from openapi_client.models.total_cost_block import TotalCostBlock
from openapi_client.models.total_holding_cost_block import TotalHoldingCostBlock
from typing import Optional, Set
from typing_extensions import Self


class CostIndicationExAnte(BaseModel):
    """
    Ex-ante cost indication on the basis of the order data.
    """  # noqa: E501

    depot_id: Optional[StrictStr] = Field(
        default=None, description="Securities account number (UUID)", alias="depotId"
    )
    calculation_successful: Optional[StrictBool] = Field(
        default=False,
        description="Result of calculation of cost indication; if false, linkCosts will link to a generic cost indication",
        alias="calculationSuccessful",
    )
    name: Optional[StrictStr] = Field(default=None, description="Instrument name analogous to Instrument.name")
    wkn: Optional[StrictStr] = Field(default=None, description="WKN analogous to Instrument.wkn")
    side: Optional[StrictStr] = Field(default=None, description="Type of transaction analogous to Order.side")
    quantity: Optional[AmountValue] = None
    limit: Optional[AmountValue] = None
    expected_value: Optional[AmountValue] = Field(default=None, alias="expectedValue")
    venue_name: Optional[StrictStr] = Field(
        default=None, description="Execution venue as name for the display", alias="venueName"
    )
    settlement_currency: Optional[StrictStr] = Field(
        default=None, description="ISO-4217 currency code", alias="settlementCurrency"
    )
    trading_currency: Optional[StrictStr] = Field(
        default=None, description="ISO-4217 currency code", alias="tradingCurrency"
    )
    reporting_currency: Optional[StrictStr] = Field(
        default=None, description="ISO-4217 currency code", alias="reportingCurrency"
    )
    fx_rate: Optional[FXRateEUR] = Field(default=None, alias="fxRate")
    expected_settlement_costs: Optional[AmountValue] = Field(default=None, alias="expectedSettlementCosts")
    purchase_costs: Optional[CostGroup] = Field(default=None, alias="purchaseCosts")
    holding_costs: Optional[CostGroup] = Field(default=None, alias="holdingCosts")
    sales_costs: Optional[CostGroup] = Field(default=None, alias="salesCosts")
    holding_period: Optional[StrictStr] = Field(
        default=None, description="Holding period in years, displayed on purchase", alias="holdingPeriod"
    )
    total_costs_abs: Optional[AmountValue] = Field(default=None, alias="totalCostsAbs")
    total_costs_rel: Optional[StrictStr] = Field(
        default=None, description="Percentage encoded as string", alias="totalCostsRel"
    )
    total_costs_detail: Optional[TotalCostBlock] = Field(default=None, alias="totalCostsDetail")
    total_holding_costs: Optional[TotalHoldingCostBlock] = Field(default=None, alias="totalHoldingCosts")
    link_costs: Optional[StrictStr] = Field(
        default=None, description="HTTP link to further cost information", alias="linkCosts"
    )
    link_kid: Optional[StrictStr] = Field(
        default=None, description="HTTP link to key information document", alias="linkKid"
    )
    __properties: ClassVar[List[str]] = [
        "depotId",
        "calculationSuccessful",
        "name",
        "wkn",
        "side",
        "quantity",
        "limit",
        "expectedValue",
        "venueName",
        "settlementCurrency",
        "tradingCurrency",
        "reportingCurrency",
        "fxRate",
        "expectedSettlementCosts",
        "purchaseCosts",
        "holdingCosts",
        "salesCosts",
        "holdingPeriod",
        "totalCostsAbs",
        "totalCostsRel",
        "totalCostsDetail",
        "totalHoldingCosts",
        "linkCosts",
        "linkKid",
    ]

    @field_validator("side")
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["BUY", "SELL"]):
            raise ValueError("must be one of enum values ('BUY', 'SELL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CostIndicationExAnte from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "depot_id",
                "calculation_successful",
                "name",
                "wkn",
                "side",
                "venue_name",
                "holding_period",
                "link_costs",
                "link_kid",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of quantity
        if self.quantity:
            _dict["quantity"] = self.quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of limit
        if self.limit:
            _dict["limit"] = self.limit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of expected_value
        if self.expected_value:
            _dict["expectedValue"] = self.expected_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fx_rate
        if self.fx_rate:
            _dict["fxRate"] = self.fx_rate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of expected_settlement_costs
        if self.expected_settlement_costs:
            _dict["expectedSettlementCosts"] = self.expected_settlement_costs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of purchase_costs
        if self.purchase_costs:
            _dict["purchaseCosts"] = self.purchase_costs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of holding_costs
        if self.holding_costs:
            _dict["holdingCosts"] = self.holding_costs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sales_costs
        if self.sales_costs:
            _dict["salesCosts"] = self.sales_costs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_costs_abs
        if self.total_costs_abs:
            _dict["totalCostsAbs"] = self.total_costs_abs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_costs_detail
        if self.total_costs_detail:
            _dict["totalCostsDetail"] = self.total_costs_detail.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_holding_costs
        if self.total_holding_costs:
            _dict["totalHoldingCosts"] = self.total_holding_costs.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CostIndicationExAnte from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "depotId": obj.get("depotId"),
                "calculationSuccessful": (
                    obj.get("calculationSuccessful") if obj.get("calculationSuccessful") is not None else False
                ),
                "name": obj.get("name"),
                "wkn": obj.get("wkn"),
                "side": obj.get("side"),
                "quantity": AmountValue.from_dict(obj["quantity"]) if obj.get("quantity") is not None else None,
                "limit": AmountValue.from_dict(obj["limit"]) if obj.get("limit") is not None else None,
                "expectedValue": (
                    AmountValue.from_dict(obj["expectedValue"]) if obj.get("expectedValue") is not None else None
                ),
                "venueName": obj.get("venueName"),
                "settlementCurrency": obj.get("settlementCurrency"),
                "tradingCurrency": obj.get("tradingCurrency"),
                "reportingCurrency": obj.get("reportingCurrency"),
                "fxRate": FXRateEUR.from_dict(obj["fxRate"]) if obj.get("fxRate") is not None else None,
                "expectedSettlementCosts": (
                    AmountValue.from_dict(obj["expectedSettlementCosts"])
                    if obj.get("expectedSettlementCosts") is not None
                    else None
                ),
                "purchaseCosts": (
                    CostGroup.from_dict(obj["purchaseCosts"]) if obj.get("purchaseCosts") is not None else None
                ),
                "holdingCosts": (
                    CostGroup.from_dict(obj["holdingCosts"]) if obj.get("holdingCosts") is not None else None
                ),
                "salesCosts": CostGroup.from_dict(obj["salesCosts"]) if obj.get("salesCosts") is not None else None,
                "holdingPeriod": obj.get("holdingPeriod"),
                "totalCostsAbs": (
                    AmountValue.from_dict(obj["totalCostsAbs"]) if obj.get("totalCostsAbs") is not None else None
                ),
                "totalCostsRel": obj.get("totalCostsRel"),
                "totalCostsDetail": (
                    TotalCostBlock.from_dict(obj["totalCostsDetail"])
                    if obj.get("totalCostsDetail") is not None
                    else None
                ),
                "totalHoldingCosts": (
                    TotalHoldingCostBlock.from_dict(obj["totalHoldingCosts"])
                    if obj.get("totalHoldingCosts") is not None
                    else None
                ),
                "linkCosts": obj.get("linkCosts"),
                "linkKid": obj.get("linkKid"),
            }
        )
        return _obj
