# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.amount_value import AmountValue
from openapi_client.models.depot import Depot
from typing import Optional, Set
from typing_extensions import Self


class DepotAggregation(BaseModel):
    """
    DepotAggregation
    """  # noqa: E501

    depot: Optional[Depot] = None
    depot_id: Optional[StrictStr] = Field(
        default=None, description="Securities account Identifier (UUID)", alias="depotId"
    )
    date_last_update: Optional[StrictStr] = Field(
        default=None,
        description="Date of the last update of securities holdings & master data. YYYY-MM-DD",
        alias="dateLastUpdate",
    )
    current_value: Optional[AmountValue] = Field(default=None, alias="currentValue")
    purchase_value: Optional[AmountValue] = Field(default=None, alias="purchaseValue")
    prev_day_value: Optional[AmountValue] = Field(default=None, alias="prevDayValue")
    lending_value: Optional[AmountValue] = Field(default=None, alias="lendingValue")
    profit_loss_purchase_abs: Optional[AmountValue] = Field(default=None, alias="profitLossPurchaseAbs")
    profit_loss_purchase_rel: Optional[StrictStr] = Field(
        default=None, description="Percentage encoded as string", alias="profitLossPurchaseRel"
    )
    profit_loss_prev_day_abs: Optional[AmountValue] = Field(default=None, alias="profitLossPrevDayAbs")
    profit_loss_prev_day_rel: Optional[StrictStr] = Field(
        default=None, description="Percentage encoded as string", alias="profitLossPrevDayRel"
    )
    __properties: ClassVar[List[str]] = [
        "depot",
        "depotId",
        "dateLastUpdate",
        "currentValue",
        "purchaseValue",
        "prevDayValue",
        "lendingValue",
        "profitLossPurchaseAbs",
        "profitLossPurchaseRel",
        "profitLossPrevDayAbs",
        "profitLossPrevDayRel",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DepotAggregation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "depot_id",
                "date_last_update",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of depot
        if self.depot:
            _dict["depot"] = self.depot.to_dict()
        # override the default output from pydantic by calling `to_dict()` of current_value
        if self.current_value:
            _dict["currentValue"] = self.current_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of purchase_value
        if self.purchase_value:
            _dict["purchaseValue"] = self.purchase_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of prev_day_value
        if self.prev_day_value:
            _dict["prevDayValue"] = self.prev_day_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lending_value
        if self.lending_value:
            _dict["lendingValue"] = self.lending_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of profit_loss_purchase_abs
        if self.profit_loss_purchase_abs:
            _dict["profitLossPurchaseAbs"] = self.profit_loss_purchase_abs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of profit_loss_prev_day_abs
        if self.profit_loss_prev_day_abs:
            _dict["profitLossPrevDayAbs"] = self.profit_loss_prev_day_abs.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DepotAggregation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "depot": Depot.from_dict(obj["depot"]) if obj.get("depot") is not None else None,
                "depotId": obj.get("depotId"),
                "dateLastUpdate": obj.get("dateLastUpdate"),
                "currentValue": (
                    AmountValue.from_dict(obj["currentValue"]) if obj.get("currentValue") is not None else None
                ),
                "purchaseValue": (
                    AmountValue.from_dict(obj["purchaseValue"]) if obj.get("purchaseValue") is not None else None
                ),
                "prevDayValue": (
                    AmountValue.from_dict(obj["prevDayValue"]) if obj.get("prevDayValue") is not None else None
                ),
                "lendingValue": (
                    AmountValue.from_dict(obj["lendingValue"]) if obj.get("lendingValue") is not None else None
                ),
                "profitLossPurchaseAbs": (
                    AmountValue.from_dict(obj["profitLossPurchaseAbs"])
                    if obj.get("profitLossPurchaseAbs") is not None
                    else None
                ),
                "profitLossPurchaseRel": obj.get("profitLossPurchaseRel"),
                "profitLossPrevDayAbs": (
                    AmountValue.from_dict(obj["profitLossPrevDayAbs"])
                    if obj.get("profitLossPrevDayAbs") is not None
                    else None
                ),
                "profitLossPrevDayRel": obj.get("profitLossPrevDayRel"),
            }
        )
        return _obj
