# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.amount_value import AmountValue
from openapi_client.models.instrument import Instrument
from openapi_client.models.price import Price
from typing import Optional, Set
from typing_extensions import Self


class DepotPosition(BaseModel):
    """
    DepotPosition
    """  # noqa: E501

    depot_id: Optional[StrictStr] = Field(
        default=None, description="Securities account Identifier (UUID)", alias="depotId"
    )
    position_id: Optional[StrictStr] = Field(
        default=None, description="Position identification number in securities account", alias="positionId"
    )
    wkn: Optional[StrictStr] = Field(default=None, description="Identification number of the instrument")
    custody_type: Optional[StrictStr] = Field(default=None, description="Custody type", alias="custodyType")
    quantity: Optional[AmountValue] = None
    available_quantity: Optional[AmountValue] = Field(default=None, alias="availableQuantity")
    current_price: Optional[Price] = Field(default=None, alias="currentPrice")
    purchase_price: Optional[AmountValue] = Field(default=None, alias="purchasePrice")
    prev_day_price: Optional[Price] = Field(default=None, alias="prevDayPrice")
    current_value: Optional[AmountValue] = Field(default=None, alias="currentValue")
    purchase_value: Optional[AmountValue] = Field(default=None, alias="purchaseValue")
    prev_day_value: Optional[AmountValue] = Field(default=None, alias="prevDayValue")
    profit_loss_purchase_abs: Optional[AmountValue] = Field(default=None, alias="profitLossPurchaseAbs")
    profit_loss_purchase_rel: Optional[StrictStr] = Field(
        default=None, description="Percentage encoded as string", alias="profitLossPurchaseRel"
    )
    profit_loss_prev_day_abs: Optional[AmountValue] = Field(default=None, alias="profitLossPrevDayAbs")
    profit_loss_prev_day_rel: Optional[StrictStr] = Field(
        default=None, description="Percentage encoded as string", alias="profitLossPrevDayRel"
    )
    instrument: Optional[Instrument] = None
    version: Optional[StrictStr] = Field(default=None, description="Position version, if available")
    __properties: ClassVar[List[str]] = [
        "depotId",
        "positionId",
        "wkn",
        "custodyType",
        "quantity",
        "availableQuantity",
        "currentPrice",
        "purchasePrice",
        "prevDayPrice",
        "currentValue",
        "purchaseValue",
        "prevDayValue",
        "profitLossPurchaseAbs",
        "profitLossPurchaseRel",
        "profitLossPrevDayAbs",
        "profitLossPrevDayRel",
        "instrument",
        "version",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DepotPosition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "depot_id",
                "position_id",
                "wkn",
                "custody_type",
                "version",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of quantity
        if self.quantity:
            _dict["quantity"] = self.quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of available_quantity
        if self.available_quantity:
            _dict["availableQuantity"] = self.available_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of current_price
        if self.current_price:
            _dict["currentPrice"] = self.current_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of purchase_price
        if self.purchase_price:
            _dict["purchasePrice"] = self.purchase_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of prev_day_price
        if self.prev_day_price:
            _dict["prevDayPrice"] = self.prev_day_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of current_value
        if self.current_value:
            _dict["currentValue"] = self.current_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of purchase_value
        if self.purchase_value:
            _dict["purchaseValue"] = self.purchase_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of prev_day_value
        if self.prev_day_value:
            _dict["prevDayValue"] = self.prev_day_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of profit_loss_purchase_abs
        if self.profit_loss_purchase_abs:
            _dict["profitLossPurchaseAbs"] = self.profit_loss_purchase_abs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of profit_loss_prev_day_abs
        if self.profit_loss_prev_day_abs:
            _dict["profitLossPrevDayAbs"] = self.profit_loss_prev_day_abs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instrument
        if self.instrument:
            _dict["instrument"] = self.instrument.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DepotPosition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "depotId": obj.get("depotId"),
                "positionId": obj.get("positionId"),
                "wkn": obj.get("wkn"),
                "custodyType": obj.get("custodyType"),
                "quantity": AmountValue.from_dict(obj["quantity"]) if obj.get("quantity") is not None else None,
                "availableQuantity": (
                    AmountValue.from_dict(obj["availableQuantity"])
                    if obj.get("availableQuantity") is not None
                    else None
                ),
                "currentPrice": Price.from_dict(obj["currentPrice"]) if obj.get("currentPrice") is not None else None,
                "purchasePrice": (
                    AmountValue.from_dict(obj["purchasePrice"]) if obj.get("purchasePrice") is not None else None
                ),
                "prevDayPrice": Price.from_dict(obj["prevDayPrice"]) if obj.get("prevDayPrice") is not None else None,
                "currentValue": (
                    AmountValue.from_dict(obj["currentValue"]) if obj.get("currentValue") is not None else None
                ),
                "purchaseValue": (
                    AmountValue.from_dict(obj["purchaseValue"]) if obj.get("purchaseValue") is not None else None
                ),
                "prevDayValue": (
                    AmountValue.from_dict(obj["prevDayValue"]) if obj.get("prevDayValue") is not None else None
                ),
                "profitLossPurchaseAbs": (
                    AmountValue.from_dict(obj["profitLossPurchaseAbs"])
                    if obj.get("profitLossPurchaseAbs") is not None
                    else None
                ),
                "profitLossPurchaseRel": obj.get("profitLossPurchaseRel"),
                "profitLossPrevDayAbs": (
                    AmountValue.from_dict(obj["profitLossPrevDayAbs"])
                    if obj.get("profitLossPrevDayAbs") is not None
                    else None
                ),
                "profitLossPrevDayRel": obj.get("profitLossPrevDayRel"),
                "instrument": Instrument.from_dict(obj["instrument"]) if obj.get("instrument") is not None else None,
                "version": obj.get("version"),
            }
        )
        return _obj
