# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.document_metadata import DocumentMetadata
from typing import Optional, Set
from typing_extensions import Self


class Document(BaseModel):
    """
    Model for a document.
    """  # noqa: E501

    document_id: Optional[StrictStr] = Field(
        default=None, description="Unique ID of the document (UUID)", alias="documentId"
    )
    name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=255)]] = Field(
        default=None, description="Name or description of the document."
    )
    date_creation: Optional[StrictStr] = Field(
        default=None, description="Date at which the Document was assigned to the client.", alias="dateCreation"
    )
    mime_type: Optional[StrictStr] = Field(
        default=None, description="The native mimeType of the document.", alias="mimeType"
    )
    deletable: Optional[StrictBool] = Field(default=False, description="Is the client allowed to delete the document?")
    advertisement: Optional[StrictBool] = Field(
        default=False, description="Is the document advertising comdirect products?"
    )
    document_meta_data: Optional[DocumentMetadata] = Field(default=None, alias="documentMetaData")
    __properties: ClassVar[List[str]] = [
        "documentId",
        "name",
        "dateCreation",
        "mimeType",
        "deletable",
        "advertisement",
        "documentMetaData",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Document from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "document_id",
                "name",
                "date_creation",
                "mime_type",
                "deletable",
                "advertisement",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of document_meta_data
        if self.document_meta_data:
            _dict["documentMetaData"] = self.document_meta_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Document from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "documentId": obj.get("documentId"),
                "name": obj.get("name"),
                "dateCreation": obj.get("dateCreation"),
                "mimeType": obj.get("mimeType"),
                "deletable": obj.get("deletable") if obj.get("deletable") is not None else False,
                "advertisement": obj.get("advertisement") if obj.get("advertisement") is not None else False,
                "documentMetaData": (
                    DocumentMetadata.from_dict(obj["documentMetaData"])
                    if obj.get("documentMetaData") is not None
                    else None
                ),
            }
        )
        return _obj
