# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class DocumentMetadata(BaseModel):
    """
    Model for category-specific metadata of documents.
    """  # noqa: E501

    archived: Optional[StrictBool] = Field(default=False, description="Is document archived?")
    date_read: Optional[StrictStr] = Field(
        default=None, description="Date on which the document was read.", alias="dateRead"
    )
    already_read: Optional[StrictBool] = Field(
        default=False, description="Has the document been read?", alias="alreadyRead"
    )
    predocument_exists: Optional[StrictBool] = Field(default=False, alias="predocumentExists")
    __properties: ClassVar[List[str]] = ["archived", "dateRead", "alreadyRead", "predocumentExists"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "archived",
                "date_read",
                "already_read",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "archived": obj.get("archived") if obj.get("archived") is not None else False,
                "dateRead": obj.get("dateRead"),
                "alreadyRead": obj.get("alreadyRead") if obj.get("alreadyRead") is not None else False,
                "predocumentExists": (
                    obj.get("predocumentExists") if obj.get("predocumentExists") is not None else False
                ),
            }
        )
        return _obj
