# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.amount_value import AmountValue
from typing import Optional, Set
from typing_extensions import Self


class Execution(BaseModel):
    """
    Model for an order's execution.
    """  # noqa: E501

    execution_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=40)]] = Field(
        default=None, description="Execution ID (UUID)", alias="executionId"
    )
    execution_number: Optional[StrictInt] = Field(
        default=None, description="Position (by time) of the execution of an order", alias="executionNumber"
    )
    executed_quantity: Optional[AmountValue] = Field(default=None, alias="executedQuantity")
    execution_price: Optional[AmountValue] = Field(default=None, alias="executionPrice")
    execution_timestamp: Optional[StrictStr] = Field(
        default=None, description="ISO-8601 timestamp", alias="executionTimestamp"
    )
    __properties: ClassVar[List[str]] = [
        "executionId",
        "executionNumber",
        "executedQuantity",
        "executionPrice",
        "executionTimestamp",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Execution from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "execution_id",
                "execution_number",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of executed_quantity
        if self.executed_quantity:
            _dict["executedQuantity"] = self.executed_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of execution_price
        if self.execution_price:
            _dict["executionPrice"] = self.execution_price.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Execution from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "executionId": obj.get("executionId"),
                "executionNumber": obj.get("executionNumber"),
                "executedQuantity": (
                    AmountValue.from_dict(obj["executedQuantity"]) if obj.get("executedQuantity") is not None else None
                ),
                "executionPrice": (
                    AmountValue.from_dict(obj["executionPrice"]) if obj.get("executionPrice") is not None else None
                ),
                "executionTimestamp": obj.get("executionTimestamp"),
            }
        )
        return _obj
