# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.amount_value import AmountValue
from typing import Optional, Set
from typing_extensions import Self


class InstallmentLoan(BaseModel):
    """
    Master data of an installment loan
    """  # noqa: E501

    installment_loan_id: Optional[StrictStr] = Field(
        default=None, description="Installment loan identifier (UUID).", alias="installmentLoanId"
    )
    product_display_id: Optional[StrictStr] = Field(
        default=None, description="SWK number of the installment loan.", alias="productDisplayId"
    )
    credit_amount: Optional[AmountValue] = Field(default=None, alias="creditAmount")
    net_credit_amount: Optional[AmountValue] = Field(default=None, alias="netCreditAmount")
    paid_out_amount: Optional[AmountValue] = Field(default=None, alias="paidOutAmount")
    installment_amount: Optional[AmountValue] = Field(default=None, alias="installmentAmount")
    contract_period_in_months: Optional[StrictInt] = Field(
        default=None, description="Runtime of the installment loan in months.", alias="contractPeriodInMonths"
    )
    effective_interest: Optional[StrictStr] = Field(
        default=None, description="Effective interest rate.", alias="effectiveInterest"
    )
    nominal_interest: Optional[StrictStr] = Field(
        default=None, description="Nominal interest rate.", alias="nominalInterest"
    )
    contract_conclusion_date: Optional[StrictStr] = Field(
        default=None, description="Date of conclusion of the installment loan.", alias="contractConclusionDate"
    )
    __properties: ClassVar[List[str]] = [
        "installmentLoanId",
        "productDisplayId",
        "creditAmount",
        "netCreditAmount",
        "paidOutAmount",
        "installmentAmount",
        "contractPeriodInMonths",
        "effectiveInterest",
        "nominalInterest",
        "contractConclusionDate",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InstallmentLoan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "installment_loan_id",
                "product_display_id",
                "contract_period_in_months",
                "effective_interest",
                "nominal_interest",
                "contract_conclusion_date",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of credit_amount
        if self.credit_amount:
            _dict["creditAmount"] = self.credit_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of net_credit_amount
        if self.net_credit_amount:
            _dict["netCreditAmount"] = self.net_credit_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of paid_out_amount
        if self.paid_out_amount:
            _dict["paidOutAmount"] = self.paid_out_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of installment_amount
        if self.installment_amount:
            _dict["installmentAmount"] = self.installment_amount.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InstallmentLoan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "installmentLoanId": obj.get("installmentLoanId"),
                "productDisplayId": obj.get("productDisplayId"),
                "creditAmount": (
                    AmountValue.from_dict(obj["creditAmount"]) if obj.get("creditAmount") is not None else None
                ),
                "netCreditAmount": (
                    AmountValue.from_dict(obj["netCreditAmount"]) if obj.get("netCreditAmount") is not None else None
                ),
                "paidOutAmount": (
                    AmountValue.from_dict(obj["paidOutAmount"]) if obj.get("paidOutAmount") is not None else None
                ),
                "installmentAmount": (
                    AmountValue.from_dict(obj["installmentAmount"])
                    if obj.get("installmentAmount") is not None
                    else None
                ),
                "contractPeriodInMonths": obj.get("contractPeriodInMonths"),
                "effectiveInterest": obj.get("effectiveInterest"),
                "nominalInterest": obj.get("nominalInterest"),
                "contractConclusionDate": obj.get("contractConclusionDate"),
            }
        )
        return _obj
