# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.dimensions import Dimensions
from openapi_client.models.fund_distribution import FundDistribution
from openapi_client.models.static_data import StaticData
from typing import Optional, Set
from typing_extensions import Self


class Instrument(BaseModel):
    """
    Model for an instrument.
    """  # noqa: E501

    instrument_id: Optional[StrictStr] = Field(
        default=None,
        description="Instrument id (UUID), unique identification of an instrument (security, derivative, etc.) for future use",
        alias="instrumentId",
    )
    wkn: Optional[StrictStr] = Field(default=None, description="WKN")
    isin: Optional[StrictStr] = Field(default=None, description="ISIN")
    mnemonic: Optional[StrictStr] = Field(default=None, description="Security symbol according to WM data-service")
    name: Optional[StrictStr] = Field(default=None, description="Name of the instrument")
    short_name: Optional[StrictStr] = Field(
        default=None, description="Short name of the instrument", alias="shortName"
    )
    static_data: Optional[StaticData] = Field(default=None, alias="staticData")
    order_dimensions: Optional[Dimensions] = Field(default=None, alias="orderDimensions")
    funds_distribution: Optional[FundDistribution] = Field(default=None, alias="fundsDistribution")
    derivative_data: Optional[DerivativeData] = Field(default=None, alias="derivativeData")
    __properties: ClassVar[List[str]] = [
        "instrumentId",
        "wkn",
        "isin",
        "mnemonic",
        "name",
        "shortName",
        "staticData",
        "orderDimensions",
        "fundsDistribution",
        "derivativeData",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Instrument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "instrument_id",
                "wkn",
                "isin",
                "mnemonic",
                "name",
                "short_name",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of static_data
        if self.static_data:
            _dict["staticData"] = self.static_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_dimensions
        if self.order_dimensions:
            _dict["orderDimensions"] = self.order_dimensions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of funds_distribution
        if self.funds_distribution:
            _dict["fundsDistribution"] = self.funds_distribution.to_dict()
        # override the default output from pydantic by calling `to_dict()` of derivative_data
        if self.derivative_data:
            _dict["derivativeData"] = self.derivative_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Instrument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "instrumentId": obj.get("instrumentId"),
                "wkn": obj.get("wkn"),
                "isin": obj.get("isin"),
                "mnemonic": obj.get("mnemonic"),
                "name": obj.get("name"),
                "shortName": obj.get("shortName"),
                "staticData": StaticData.from_dict(obj["staticData"]) if obj.get("staticData") is not None else None,
                "orderDimensions": (
                    Dimensions.from_dict(obj["orderDimensions"]) if obj.get("orderDimensions") is not None else None
                ),
                "fundsDistribution": (
                    FundDistribution.from_dict(obj["fundsDistribution"])
                    if obj.get("fundsDistribution") is not None
                    else None
                ),
                "derivativeData": (
                    DerivativeData.from_dict(obj["derivativeData"]) if obj.get("derivativeData") is not None else None
                ),
            }
        )
        return _obj


from openapi_client.models.derivative_data import DerivativeData

# TODO: Rewrite to not use raise_errors
Instrument.model_rebuild(raise_errors=False)
