# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.amount_value import AmountValue
from openapi_client.models.execution import Execution
from typing import Optional, Set
from typing_extensions import Self


class Order(BaseModel):
    """
    Model for an order.
    """  # noqa: E501

    depot_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=40)]] = Field(
        default=None, description="Unique securities account identification (as UUID)", alias="depotId"
    )
    settlement_account_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=40)]] = Field(
        default=None,
        description="Reference settlement account for the securities account, if different from the settlement account assigned directly to the securities account (UUID)",
        alias="settlementAccountId",
    )
    order_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=40)]] = Field(
        default=None, description="Unique order-Id (UUID)", alias="orderId"
    )
    creation_timestamp: Optional[StrictStr] = Field(
        default=None, description="ISO-8601 timestamp", alias="creationTimestamp"
    )
    leg_number: Optional[StrictInt] = Field(
        default=None, description="Order leg number (if ordertype is OCO or NEO)", alias="legNumber"
    )
    best_ex: Optional[StrictBool] = Field(
        default=False, description="Flag if order is a best-execution-order, default value is false", alias="bestEx"
    )
    order_type: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=30)]] = Field(
        default=None,
        description="Ordertype, partially executed and open orders are listed in the execution parameters",
        alias="orderType",
    )
    order_status: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=30)]] = Field(
        default=None, description="Status of the order", alias="orderStatus"
    )
    sub_orders: Optional[List[Order]] = Field(
        default=None,
        description="Parts of the orders, e.g. combination orders OCO, NEO (Next Order) with different order legs or partially executed or partially cancelled orders with different parts of an order",
        alias="subOrders",
    )
    side: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=4)]] = Field(
        default=None, description="Type of transaction"
    )
    instrument_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=40)]] = Field(
        default=None,
        description="WKN, ISIN or uuId; wkn will be returned if instrumentId is entered as wkn, an ISIN is returned if instrumentId is entered as ISIN, a uuId is returned if instrumentId is entered as uuId",
        alias="instrumentId",
    )
    quote_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=40)]] = Field(
        default=None,
        description="Quote-Id as reference for the quote received from the trading venue (issuer or exchange) on the quote request",
        alias="quoteId",
    )
    venue_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=40)]] = Field(
        default=None,
        description="UUID of the trading venue or partner. This is mandatory, if isBestEx=FALSE",
        alias="venueId",
    )
    quantity: Optional[AmountValue] = None
    open_quantity: Optional[AmountValue] = Field(default=None, alias="openQuantity")
    cancelled_quantity: Optional[AmountValue] = Field(default=None, alias="cancelledQuantity")
    executed_quantity: Optional[AmountValue] = Field(default=None, alias="executedQuantity")
    limit_extension: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=3)]] = Field(
        default=None,
        description="Order extensions (Fill-or-Kill, Immediate-or-Cancel, All-or-None)",
        alias="limitExtension",
    )
    trading_restriction: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=3)]] = Field(
        default=None,
        description="Restrictions on trade (Opening Auction Only, Auction Only, Closing Auction Only)",
        alias="tradingRestriction",
    )
    limit: Optional[AmountValue] = None
    trigger_limit: Optional[AmountValue] = Field(default=None, alias="triggerLimit")
    trailing_limit_dist_abs: Optional[AmountValue] = Field(default=None, alias="trailingLimitDistAbs")
    trailing_limit_dist_rel: Optional[StrictStr] = Field(
        default=None, description="Percentage encoded as string", alias="trailingLimitDistRel"
    )
    validity_type: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=3)]] = Field(
        default=None,
        description="Type of order validity (Good-for-day (default), Good-til-date (incl. end of month))",
        alias="validityType",
    )
    validity: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None, description="ISO-8601 date (YYYY-MM-DD)"
    )
    expected_value: Optional[AmountValue] = Field(default=None, alias="expectedValue")
    executions: Optional[List[Execution]] = Field(default=None, description="List of execution types for the order")
    quote_ticket_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=40)]] = Field(
        default=None,
        description="Ticket UUID for the quote order. This is mandatory, if for a quote order",
        alias="quoteTicketId",
    )
    version: Optional[StrictStr] = Field(
        default=None, description="Version of the position to be sold. Only applicable for sell"
    )
    __properties: ClassVar[List[str]] = [
        "depotId",
        "settlementAccountId",
        "orderId",
        "creationTimestamp",
        "legNumber",
        "bestEx",
        "orderType",
        "orderStatus",
        "subOrders",
        "side",
        "instrumentId",
        "quoteId",
        "venueId",
        "quantity",
        "openQuantity",
        "cancelledQuantity",
        "executedQuantity",
        "limitExtension",
        "tradingRestriction",
        "limit",
        "triggerLimit",
        "trailingLimitDistAbs",
        "trailingLimitDistRel",
        "validityType",
        "validity",
        "expectedValue",
        "executions",
        "quoteTicketId",
        "version",
    ]

    @field_validator("order_type")
    def order_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            [
                "MARKET",
                "LIMIT",
                "QUOTE",
                "STOP_MARKET",
                "STOP_LIMIT",
                "TRAILING_STOP_MARKET",
                "TRAILING_STOP_LIMIT",
                "ONE_CANCELS_OTHER",
                "NEXT_ORDER",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('MARKET', 'LIMIT', 'QUOTE', 'STOP_MARKET', 'STOP_LIMIT', 'TRAILING_STOP_MARKET', 'TRAILING_STOP_LIMIT', 'ONE_CANCELS_OTHER', 'NEXT_ORDER')"
            )
        return value

    @field_validator("order_status")
    def order_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            [
                "PENDING",
                "OPEN",
                "EXECUTED",
                "SETTLED",
                "CANCELLED_USER",
                "EXPIRED",
                "CANCELLED_SYSTEM",
                "CANCELLED_TRADE",
                "UNKNOWN",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('PENDING', 'OPEN', 'EXECUTED', 'SETTLED', 'CANCELLED_USER', 'EXPIRED', 'CANCELLED_SYSTEM', 'CANCELLED_TRADE', 'UNKNOWN')"
            )
        return value

    @field_validator("side")
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["BUY", "SELL"]):
            raise ValueError("must be one of enum values ('BUY', 'SELL')")
        return value

    @field_validator("limit_extension")
    def limit_extension_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["FOK", "IOC", "AON"]):
            raise ValueError("must be one of enum values ('FOK', 'IOC', 'AON')")
        return value

    @field_validator("trading_restriction")
    def trading_restriction_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["OAO", "AO", "CAO"]):
            raise ValueError("must be one of enum values ('OAO', 'AO', 'CAO')")
        return value

    @field_validator("validity_type")
    def validity_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["GFD", "GTD"]):
            raise ValueError("must be one of enum values ('GFD', 'GTD')")
        return value

    @field_validator("validity")
    def validity_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{4}-\d{2}-\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Order from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "order_id",
                "leg_number",
                "order_status",
                "executions",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sub_orders (list)
        _items = []
        if self.sub_orders:
            for _item_sub_orders in self.sub_orders:
                if _item_sub_orders:
                    _items.append(_item_sub_orders.to_dict())
            _dict["subOrders"] = _items
        # override the default output from pydantic by calling `to_dict()` of quantity
        if self.quantity:
            _dict["quantity"] = self.quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of open_quantity
        if self.open_quantity:
            _dict["openQuantity"] = self.open_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cancelled_quantity
        if self.cancelled_quantity:
            _dict["cancelledQuantity"] = self.cancelled_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of executed_quantity
        if self.executed_quantity:
            _dict["executedQuantity"] = self.executed_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of limit
        if self.limit:
            _dict["limit"] = self.limit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trigger_limit
        if self.trigger_limit:
            _dict["triggerLimit"] = self.trigger_limit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trailing_limit_dist_abs
        if self.trailing_limit_dist_abs:
            _dict["trailingLimitDistAbs"] = self.trailing_limit_dist_abs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of expected_value
        if self.expected_value:
            _dict["expectedValue"] = self.expected_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in executions (list)
        _items = []
        if self.executions:
            for _item_executions in self.executions:
                if _item_executions:
                    _items.append(_item_executions.to_dict())
            _dict["executions"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Order from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "depotId": obj.get("depotId"),
                "settlementAccountId": obj.get("settlementAccountId"),
                "orderId": obj.get("orderId"),
                "creationTimestamp": obj.get("creationTimestamp"),
                "legNumber": obj.get("legNumber"),
                "bestEx": obj.get("bestEx") if obj.get("bestEx") is not None else False,
                "orderType": obj.get("orderType"),
                "orderStatus": obj.get("orderStatus"),
                "subOrders": (
                    [Order.from_dict(_item) for _item in obj["subOrders"]]
                    if obj.get("subOrders") is not None
                    else None
                ),
                "side": obj.get("side"),
                "instrumentId": obj.get("instrumentId"),
                "quoteId": obj.get("quoteId"),
                "venueId": obj.get("venueId"),
                "quantity": AmountValue.from_dict(obj["quantity"]) if obj.get("quantity") is not None else None,
                "openQuantity": (
                    AmountValue.from_dict(obj["openQuantity"]) if obj.get("openQuantity") is not None else None
                ),
                "cancelledQuantity": (
                    AmountValue.from_dict(obj["cancelledQuantity"])
                    if obj.get("cancelledQuantity") is not None
                    else None
                ),
                "executedQuantity": (
                    AmountValue.from_dict(obj["executedQuantity"]) if obj.get("executedQuantity") is not None else None
                ),
                "limitExtension": obj.get("limitExtension"),
                "tradingRestriction": obj.get("tradingRestriction"),
                "limit": AmountValue.from_dict(obj["limit"]) if obj.get("limit") is not None else None,
                "triggerLimit": (
                    AmountValue.from_dict(obj["triggerLimit"]) if obj.get("triggerLimit") is not None else None
                ),
                "trailingLimitDistAbs": (
                    AmountValue.from_dict(obj["trailingLimitDistAbs"])
                    if obj.get("trailingLimitDistAbs") is not None
                    else None
                ),
                "trailingLimitDistRel": obj.get("trailingLimitDistRel"),
                "validityType": obj.get("validityType"),
                "validity": obj.get("validity"),
                "expectedValue": (
                    AmountValue.from_dict(obj["expectedValue"]) if obj.get("expectedValue") is not None else None
                ),
                "executions": (
                    [Execution.from_dict(_item) for _item in obj["executions"]]
                    if obj.get("executions") is not None
                    else None
                ),
                "quoteTicketId": obj.get("quoteTicketId"),
                "version": obj.get("version"),
            }
        )
        return _obj


# TODO: Rewrite to not use raise_errors
Order.model_rebuild(raise_errors=False)
