# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.balance import Balance
from typing import Optional, Set
from typing_extensions import Self


class ProductBalance(BaseModel):
    """
    Model for a product balance.
    """  # noqa: E501

    product_id: Optional[StrictStr] = Field(
        default=None, description="Unique ID of the product (UUID).", alias="productId"
    )
    product_type: Optional[StrictStr] = Field(default=None, description="Type of the product.", alias="productType")
    target_client_id: Optional[StrictStr] = Field(
        default=None, description="Unique Id of the target client (UUID).", alias="targetClientId"
    )
    client_connection_type: Optional[StrictStr] = Field(
        default=None, description="Type of the client connection.", alias="clientConnectionType"
    )
    balance: Optional[Balance] = None
    __properties: ClassVar[List[str]] = [
        "productId",
        "productType",
        "targetClientId",
        "clientConnectionType",
        "balance",
    ]

    @field_validator("product_type")
    def product_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["ACCOUNT", "CARD", "DEPOT", "LOAN", "SAVINGS"]):
            raise ValueError("must be one of enum values ('ACCOUNT', 'CARD', 'DEPOT', 'LOAN', 'SAVINGS')")
        return value

    @field_validator("client_connection_type")
    def client_connection_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["CURRENT_CLIENT", "OTHER_COMDIRECT", "OTHER_EXTERNAL"]):
            raise ValueError("must be one of enum values ('CURRENT_CLIENT', 'OTHER_COMDIRECT', 'OTHER_EXTERNAL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProductBalance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "product_id",
                "product_type",
                "target_client_id",
                "client_connection_type",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of balance
        if self.balance:
            _dict["balance"] = self.balance.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProductBalance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "productId": obj.get("productId"),
                "productType": obj.get("productType"),
                "targetClientId": obj.get("targetClientId"),
                "clientConnectionType": obj.get("clientConnectionType"),
                "balance": Balance.from_dict(obj["balance"]) if obj.get("balance") is not None else None,
            }
        )
        return _obj
