# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.amount_value import AmountValue
from typing import Optional, Set
from typing_extensions import Self


class Quote(BaseModel):
    """
    Model for a quote request.
    """  # noqa: E501

    depot_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=40)]] = Field(
        default=None, description="Unique securities account identification (as UUID)", alias="depotId"
    )
    side: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=4)]] = Field(
        default=None, description="Type of transaction"
    )
    instrument_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=40)]] = Field(
        default=None,
        description="WKN, ISIN or uuId; wkn will be returned if instrumentId is entered as wkn, an ISIN is returned if instrumentId is entered as ISIN, a uuId is returned if instrumentId is entered as uuId",
        alias="instrumentId",
    )
    venue_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=40)]] = Field(
        default=None,
        description="UUID of the trading venue or partner. This is mandatory, if isBestEx=FALSE",
        alias="venueId",
    )
    quantity: Optional[AmountValue] = None
    __properties: ClassVar[List[str]] = ["depotId", "side", "instrumentId", "venueId", "quantity"]

    @field_validator("side")
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["BUY", "SELL"]):
            raise ValueError("must be one of enum values ('BUY', 'SELL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Quote from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of quantity
        if self.quantity:
            _dict["quantity"] = self.quantity.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Quote from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "depotId": obj.get("depotId"),
                "side": obj.get("side"),
                "instrumentId": obj.get("instrumentId"),
                "venueId": obj.get("venueId"),
                "quantity": AmountValue.from_dict(obj["quantity"]) if obj.get("quantity") is not None else None,
            }
        )
        return _obj
