# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class StaticData(BaseModel):
    """
    Static data of the instrument.
    """  # noqa: E501

    notation: Optional[StrictStr] = Field(default=None, description="Ticker symbol or notation of a security")
    currency: Optional[StrictStr] = Field(default=None, description="ISO-4217 currency code")
    instrument_type: Optional[StrictStr] = Field(default=None, description="Instrument type", alias="instrumentType")
    priips_relevant: Optional[StrictBool] = Field(
        default=False,
        description="Flag indicating - if TRUE - that EU-regulation referring to Packaged Retail and Insurance-based Investment Products - PRIIPs) is relevant for the instrument",
        alias="priipsRelevant",
    )
    kid_available: Optional[StrictBool] = Field(
        default=False,
        description="Flag indicating - if TRUE - that a Key Information Document (KID) of the issuer is electronically available. Before order placement a static note ought to displayed in such a case.",
        alias="kidAvailable",
    )
    shipping_waiver_required: Optional[StrictBool] = Field(
        default=False,
        description="Flag indicating - if TRUE - that within prevalidation and before placement of a buy order the investor must approve, e.g., by a frontend checkbox that no shipping of fund sales information is required (waiver); a static note regarding that information ought to be displayed in such a case. Without an explicit waiver the order placement must be prevented in the frontend.",
        alias="shippingWaiverRequired",
    )
    fund_redemption_limited: Optional[StrictBool] = Field(
        default=False,
        description="Flag indicating - if TRUE - that within prevalidation and before placement of a buy order a static note must be displayed indicating that the redemption of the fund is limited.",
        alias="fundRedemptionLimited",
    )
    __properties: ClassVar[List[str]] = [
        "notation",
        "currency",
        "instrumentType",
        "priipsRelevant",
        "kidAvailable",
        "shippingWaiverRequired",
        "fundRedemptionLimited",
    ]

    @field_validator("notation")
    def notation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["XXX", "XXC", "XXM", "XXP", "XXU"]):
            raise ValueError("must be one of enum values ('XXX', 'XXC', 'XXM', 'XXP', 'XXU')")
        return value

    @field_validator("instrument_type")
    def instrument_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            [
                "SHARE",
                "BONDS",
                "SUBSCRIPTION_RIGHT",
                "ETF",
                "PROFIT_PART_CERTIFICATE",
                "FUND",
                "WARRANT",
                "CERTIFICATE",
                "NOT_AVAILABLE",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('SHARE', 'BONDS', 'SUBSCRIPTION_RIGHT', 'ETF', 'PROFIT_PART_CERTIFICATE', 'FUND', 'WARRANT', 'CERTIFICATE', 'NOT_AVAILABLE')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StaticData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "notation",
                "instrument_type",
                "priips_relevant",
                "kid_available",
                "shipping_waiver_required",
                "fund_redemption_limited",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StaticData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "notation": obj.get("notation"),
                "currency": obj.get("currency"),
                "instrumentType": obj.get("instrumentType"),
                "priipsRelevant": obj.get("priipsRelevant") if obj.get("priipsRelevant") is not None else False,
                "kidAvailable": obj.get("kidAvailable") if obj.get("kidAvailable") is not None else False,
                "shippingWaiverRequired": (
                    obj.get("shippingWaiverRequired") if obj.get("shippingWaiverRequired") is not None else False
                ),
                "fundRedemptionLimited": (
                    obj.get("fundRedemptionLimited") if obj.get("fundRedemptionLimited") is not None else False
                ),
            }
        )
        return _obj
