# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.amount_value import AmountValue
from typing import Optional, Set
from typing_extensions import Self


class TotalHoldingCostEntry(BaseModel):
    """
    Model for cost block over time.
    """  # noqa: E501

    type: Optional[StrictStr] = Field(default=None, description="Type of total holding cost entry")
    amount: Optional[AmountValue] = None
    average_return_pa: Optional[StrictStr] = Field(
        default=None, description="Percentage encoded as string", alias="averageReturnPA"
    )
    __properties: ClassVar[List[str]] = ["type", "amount", "averageReturnPA"]

    @field_validator("type")
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["IM_ERSTEN_JAHR", "IM_ZWEITEN_JAHR", "IM_JAHR_DER_VERAUESSERUNG"]):
            raise ValueError(
                "must be one of enum values ('IM_ERSTEN_JAHR', 'IM_ZWEITEN_JAHR', 'IM_JAHR_DER_VERAUESSERUNG')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TotalHoldingCostEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "type",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of amount
        if self.amount:
            _dict["amount"] = self.amount.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TotalHoldingCostEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "amount": AmountValue.from_dict(obj["amount"]) if obj.get("amount") is not None else None,
                "averageReturnPA": obj.get("averageReturnPA"),
            }
        )
        return _obj
