# coding: utf-8

"""
    comdirect REST API

    Please have a look at the interfaces of comdirect REST API below. Note: Currently it is not possible to request an access token via swagger UI tools because of comdirect's proprietary authorization flow. The shown error message is due to that circumstance.

    The version of the OpenAPI document: 20.04
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.order_type import OrderType
from typing import Optional, Set
from typing_extensions import Self


class Venue(BaseModel):
    """
    Model for a venue.
    """  # noqa: E501

    name: Optional[StrictStr] = None
    venue_id: Optional[StrictStr] = Field(default=None, alias="venueId")
    country: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    currencies: Optional[List[StrictStr]] = None
    sides: Optional[List[StrictStr]] = None
    validity_types: Optional[List[StrictStr]] = Field(default=None, alias="validityTypes")
    order_types: Optional[Dict[str, OrderType]] = Field(default=None, alias="orderTypes")
    __properties: ClassVar[List[str]] = [
        "name",
        "venueId",
        "country",
        "type",
        "currencies",
        "sides",
        "validityTypes",
        "orderTypes",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Venue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in order_types (dict)
        _field_dict = {}
        if self.order_types:
            for _key_order_types in self.order_types:
                if self.order_types[_key_order_types]:
                    _field_dict[_key_order_types] = self.order_types[_key_order_types].to_dict()
            _dict["orderTypes"] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Venue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "venueId": obj.get("venueId"),
                "country": obj.get("country"),
                "type": obj.get("type"),
                "currencies": obj.get("currencies"),
                "sides": obj.get("sides"),
                "validityTypes": obj.get("validityTypes"),
                "orderTypes": (
                    dict((_k, OrderType.from_dict(_v)) for _k, _v in obj["orderTypes"].items())
                    if obj.get("orderTypes") is not None
                    else None
                ),
            }
        )
        return _obj
