       # Commit-Gen - AI-Powered Git Commit Message Generator

[![PyPI version](https://badge.fury.io/py/commit-gen.svg)](https://badge.fury.io/py/commit-gen)
[![Python 3.8+](https://img.shields.io/badge/python-3.8+-blue.svg)](https://www.python.org/downloads/)

**Generate intelligent commit messages using AI with support for multiple providers including OpenRouter, Ollama, Google Gemini, and Mistral AI.**

## 🚀 Quick Start

### Installation

```bash
pip install commit-gen
```

### First Time Setup

```bash
# Interactive setup wizard (recommended)
commit-gen --setup

# Or manual setup
commit-gen --set-provider openrouter
commit-gen --set-api-key YOUR_API_KEY
```

### Basic Usage

```bash
# Interactive file selection and commit
commit-gen

# Commit specific files
commit-gen --files src/main.py tests/test_main.py

# Commit all files
commit-gen --all

# Commit and push
commit-gen --push
```

## ✨ Key Features

- **🤖 AI-Powered**: Generate commit messages using advanced AI models
- **📁 Interactive File Selection**: Choose which files to commit with arrow key navigation
- **🔧 Multiple AI Providers**: Support for OpenRouter, Ollama, Google Gemini, Mistral AI
- **⚙️ Easy Configuration**: Interactive setup wizard and simple CLI commands
- **📝 Smart Review**: Edit and confirm commit messages before committing
- **🚀 Auto Push**: Optional automatic push to remote repository

## 🛠️ Supported AI Providers

| Provider | Type | Default Model | API Key Required |
|----------|------|---------------|------------------|
| **OpenRouter** | Cloud | moonshotai/kimi-k2:free | ✅ |
| **Ollama** | Local | qwen2.5-coder:7b | ❌ |
| **Google Gemini** | Cloud | gemini-2.5-flash | ✅ |
| **Mistral AI** | Cloud | mistral-large-2411 | ✅ |
| **Custom** | Any | Configurable | ✅ |

## 📖 Usage Examples

### Interactive File Selection

```bash
commit-gen
```

Shows an interactive interface where you can:
- Navigate files with ↑/↓ arrow keys
- Toggle selection with SPACE
- See file status (modified, added, untracked)

### File Selection Interface

When you run `commit-gen` without arguments, you'll see an interactive interface with arrow key navigation:

```
📁 Files to commit:
============================================================
Use ↑/↓ to navigate, SPACE to toggle, ENTER to confirm
a=select all, n=select none, s=skip (stage all), q=quit

📂 CODE:
→ [ ] commit_gen/cli.py (modified, 18KB)
  [x] demo_file2.py (added, 13B) ✅
  [ ] README.md (modified, 9KB)
  [ ] arrow_config.json (untracked, 12B)

Selected: 1/4 files
```

**Navigation Controls:**
- **↑/↓ Arrow Keys**: Navigate through files
- **SPACE**: Toggle file selection (check/uncheck)
- **ENTER**: Confirm selection and proceed
- **a**: Select all files
- **n**: Select none (use only already staged files)
- **s**: Skip selection (stage all files)
- **q**: Quit without committing

**Visual Indicators:**
- **→**: Current cursor position
- **[x]**: Selected file
- **[ ]**: Unselected file
- **✅**: Already staged file
- **Selected: X/Y files**: Shows selection count

**Features:**
- **Status indicators**: Shows if files are modified, added, or untracked
- **Size information**: Displays file sizes
- **Staged markers**: Shows which files are already staged
- **Real-time selection**: See selection count update as you navigate
- **Keyboard navigation**: Intuitive arrow key and spacebar controls

### Commit Confirmation

After selecting files, commit-gen will:

1. **Generate AI commit message**
2. **Show commit message for review**
3. **Allow editing** (with external editor or simple input)
4. **Confirm before committing**

**Commit Review Interface:**
```
🤖 Generating commit message...

📝 Edit commit message:
============================================================
Current commit message:
------------------------------
feat: add interactive file selection with arrow keys

- Implement arrow key navigation for file selection
- Add spacebar toggle for file selection
- Improve UX with visual indicators and real-time feedback
------------------------------

Options:
1. Edit message
2. Use as-is
3. Cancel
```

**Commit Confirmation:**
```
🔍 Commit Review:
============================================================
Commit message:
------------------------------
feat: add interactive file selection with arrow keys

- Implement arrow key navigation for file selection
- Add spacebar toggle for file selection
- Improve UX with visual indicators and real-time feedback
------------------------------

Options:
1. ✅ Yes, commit
2. 🚀 Yes, commit and push
3. ❌ No, go back to editing
4. 🚪 Cancel
```

**Confirmation Options:**
- **Yes, commit**: Commit only
- **Yes, commit and push**: Commit and push to remote
- **No, go back to editing**: Return to edit commit message
- **Cancel**: Exit without committing

**Editing Options:**
- **External Editor**: Uses `$EDITOR` (default: nano)
- **Simple Input**: Fallback if editor not available
- **Validation**: Ensures commit message is not empty

### Quick Commits

```bash
# Commit specific files
commit-gen --files src/main.py tests/test_main.py

# Commit all modified files
commit-gen --all

# Commit and push automatically
commit-gen --push
```

### Provider Configuration

```bash
# Set provider
commit-gen --set-provider gemini

# Set API key
commit-gen --set-api-key YOUR_API_KEY

# Set custom model
commit-gen --set-model gemini-2.5-pro

# View current config
commit-gen --config
```

## 🔧 Configuration

### Interactive Setup (Recommended)

```bash
commit-gen --setup
```

Guides you through:
- Provider selection
- API key configuration
- Model selection
- Connection testing

### Manual Configuration

```bash
# Show available providers
commit-gen --providers

# Configure OpenRouter
commit-gen --set-provider openrouter
commit-gen --set-api-key YOUR_OPENROUTER_KEY

# Configure Ollama (local)
commit-gen --set-provider ollama
# No API key needed for Ollama

# Configure Google Gemini
commit-gen --set-provider gemini
commit-gen --set-api-key YOUR_GEMINI_KEY

# Configure Mistral AI
commit-gen --set-provider mistral
commit-gen --set-api-key YOUR_MISTRAL_KEY
```

## 🎯 Advanced Features

### Custom Prompts

```bash
commit-gen --prompt "Generate a conventional commit message: {changes}"
```

### Changelog Generation

```bash
commit-gen --changelog
commit-gen --changelog --compare-branch develop
```

### Debug Mode

```bash
commit-gen --debug
```

### Troubleshooting

### Issue: Command not found after installation

If `commit-gen` command is not found after installation:

1. **Check if symlink exists:**
   ```bash
   ls -la /usr/local/bin/commit-gen
   ```

2. **If symlink is broken, recreate it:**
   ```bash
   sudo ln -s /path/to/your/project/commit-gen.py /usr/local/bin/commit-gen
   ```

3. **For pip installation, check PATH:**
   ```bash
   which commit-gen
   echo $PATH
   ```

### Issue: Configuration files not cleaned up

If configuration files remain after uninstallation:

```bash
rm -rf ~/.config/git-commit-ai/
```

## 📋 Requirements

- **Python**: 3.8 or higher
- **Git**: Working git repository
- **AI Provider**: At least one AI provider configured

## 🤝 Contributing

We welcome contributions! Please see our [Contributing Guide](https://gitlab.mobio.vn/mobio/tools/gen-commit-message) for details.

## 📄 License

This project is licensed under the MIT License - see the [LICENSE](https://gitlab.mobio.vn/mobio/tools/gen-commit-message/-/blob/main/LICENSE) file for details.

## 🙏 Acknowledgments
- Powered by various AI providers
- Inspired by the need for better commit messages
