from __future__ import annotations

from dataclasses import dataclass
from pathlib import Path
from typing import Any, Dict, cast

TRUST_FILE = Path(".commit-memos/trust.yml")

yaml: Any
try:
    import yaml as _yaml

    yaml = _yaml
except ModuleNotFoundError:
    yaml = cast(Any, None)

TRUST_FILE = Path(".commit-memos/trust.yml")


def _require_yaml() -> None:
    if yaml is None:
        raise RuntimeError("PyYAML is required. Install with: pip install PyYAML")


@dataclass
class Trust:
    users: Dict[str, str]

    @classmethod
    def load(cls) -> "Trust":
        if not TRUST_FILE.exists():
            TRUST_FILE.parent.mkdir(parents=True, exist_ok=True)
            TRUST_FILE.write_text("users: {}\n")
        data = yaml.safe_load(TRUST_FILE.read_text()) or {"users": {}}
        return cls(users={k: str(v) for k, v in (data.get("users") or {}).items()})

    def save(self) -> None:
        TRUST_FILE.parent.mkdir(parents=True, exist_ok=True)
        TRUST_FILE.write_text(yaml.safe_dump({"users": self.users}, sort_keys=True))
