[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![Tests](https://github.com/andrecosta99/ct-final/actions/workflows/test.yml/badge.svg?branch=master)](https://github.com/andrecosta99/ct-final/actions/workflows/test.yml)
[![codecov](https://codecov.io/gh/andrecosta99/ct-final/branch/master/graph/badge.svg)](https://codecov.io/gh/andrecosta99/ct-final)
[![Docs](https://img.shields.io/badge/docs-click%20here-blue.svg)](https://andrecosta99.github.io/ct-final/)
[![PyPI version](https://badge.fury.io/py/commit-tracker.svg)](https://badge.fury.io/py/commit-tracker)
![GitHub last commit](https://img.shields.io/github/last-commit/andrecosta99/ct-final)
![GitHub forks](https://img.shields.io/github/forks/andrecosta99/ct-final)


# Commit Tracker

Commit Tracker is a tool designed to fetch and present comprehensive statistics from Git repositories. Whether the repository is hosted locally or on platforms like GitHub, Commit Tracker seamlessly analyzes commit history, contribution patterns, and other vital metrics. This utility is particularly useful for developers and teams looking to gain insights into project trends, contributor activity, and overall repository health. Built with Python and leveraging technologies such as Dash and Plotly, it provides an interactive and visually appealing interface for data representation.

## Features

- **Repository Analysis**: Obtain a detailed view of repository activity, including commits over time, contributions by author, and types of commits.
- **Interactive Interface**: Explore statistics through an interactive web interface created with Dash and Plotly.
- **Support for Local and Remote Repositories**: Works with both local Git repositories and remote repository URLs.

## Installation

To install Commit Tracker, ensure you have Python installed on your system, and run:

```bash
pip install commit-tracker
```

## Usage
After installation, you can start the application by running:

```bash
committracker
```
Follow the instructions in the web interface to input the path or URL of the Git repository you wish to analyze.

## Contributing
Contributions to Commit Tracker are welcome! If you've found a bug or have a suggestion, please open an issue on GitHub.

## License
Commit Tracker is licensed under the MIT License. See the LICENSE file for more details.
