# -*- coding: utf-8 -*-
from distutils.core import setup

packages = \
['commitizen',
 'commitizen.cz',
 'commitizen.cz.conventional_commits',
 'commitizen.cz.jira']

package_data = \
{'': ['*']}

install_requires = \
['delegator.py>=0.1.1,<0.2.0', 'questionary>=1.0,<2.0']

entry_points = \
{'console_scripts': ['cz = commitizen.cli:main']}

setup_kwargs = {
    'name': 'commitizen',
    'version': '1.0.0b2',
    'description': 'Python commitizen client tool',
    'long_description': '=============\nCommitizen\n=============\n\n    Python 3 command line utility to standardize commit messages\n\n\n.. image:: https://img.shields.io/badge/Conventional%20Commits-1.0.0-yellow.svg?style=flat-square\n    :alt: Conventional Commits\n    :target: https://conventionalcommits.org\n\n.. image:: https://img.shields.io/pypi/v/commitizen.svg?style=flat-square\n    :alt: PyPI Package latest release\n    :target: https://pypi.org/project/commitizen/\n\n..  image:: https://img.shields.io/pypi/pyversions/commitizen.svg?style=flat-square\n    :alt: Supported versions\n    :target: https://pypi.org/project/commitizen/\n\n.. image:: docs/images/demo.gif\n    :alt: Example running commitizen\n\n.. contents::\n    :depth: 2\n\n.. warning::\n\n    Beta is available and has support only for python 3\n\n\nAbout\n==========\n\nThis is an interactive tool to commit based on some rules (like conventional commits).\n\nIt comes with some defaults commit styles, like conventional commits and jira and it\'s easily extendable.\n\nIt\'s useful for teams, because it is possible to standardize the commiting style.\n\n\nInstallation\n=============\n\n::\n\n    pip install commitizen\n\n\nFor beta\n\n::\n\n    sudo pip3 install -U commitizen --pre\n\n\nInformation\n===========\n\nThis client tool prompts the user with information about the commit.\n\nBased on `conventional commits <https://conventionalcommits.org/>`_\n\nThis is an example of how the git messages history would look like:\n\n::\n\n    BREAKING CHANGE: command send has been removed\n    fix: minor typos in code\n    feat: new command update\n    docs: improved commitizens tab in readme\n    feat(cz): jira smart commits\n    refactor(cli): renamed all to ls command\n    feat: info command for angular\n    docs(README): added badges\n    docs(README): added about, installation, creating, etc\n    feat(config): new loads from ~/.cz and working project .cz .cz.cfg and setup.cfg\n\nCommitizens\n===========\n\nThese are the available commiting styles by default:\n\n* cz_conventional_commits: `conventional commits <https://conventionalcommits.org/>`_\n* cz_jira: `jira smart commits <https://confluence.atlassian.com/fisheye/using-smart-commits-298976812.html>`_\n\n\nThe installed ones can be checked with:\n\n::\n\n    cz ls\n\n\n\nCommiting\n=========\n\nRun in your terminal\n\n::\n\n    cz commit\n\nor the shortcut\n\n::\n\n    cz c\n\n\nUsage\n=====\n\n::\n\n    usage: cz [-h] [--debug] [-n NAME] [--version]\n            {ls,commit,c,example,info,schema} ...\n\n    Commitizen is a cli tool to generate conventional commits.\n    For more information about the topic go to https://conventionalcommits.org/\n\n    optional arguments:\n    -h, --help            show this help message and exit\n    --debug               use debug mode\n    -n NAME, --name NAME  use the given commitizen\n    --version             get the version of the installed commitizen\n\n    commands:\n    {ls,commit,c,example,info,schema}\n        ls                  show available commitizens\n        commit (c)          create new commit\n        example             show commit example\n        info                show information about the cz\n        schema              show commit schema\n\n\nConfiguration\n==============\n\nYou can create in your project folder a file called :code:`.cz`, :code:`.cz.cfg` or in your :code:`setup.cfg`\nor if you want to configure the global default in your user\'s home folder a :code:`.cz` file\nwith the following information:\n\n::\n\n    [commitizen]\n    name = cz_conventional_commits\n\n\nCreating a commiter\n========================\n\nCreate a file starting with :code:`cz_` for example :code:`cz_jira.py`.\nThis prefix is used to detect the plugin. Same method `flask uses <http://flask.pocoo.org/docs/0.12/extensiondev/>`_\n\nInherit from :code:`BaseCommitizen` and you must define :code:`questions`\nand :code:`message`. The others are optionals.\n\n\n.. code-block:: python\n\n    from commitizen import BaseCommitizen\n\n    class JiraCz(BaseCommitizen):\n\n        def questions(self):\n            """Questions regarding the commit message.\n\n            Must have \'whaaaaat\' format.\n            More info: https://github.com/finklabs/whaaaaat/\n\n            :rtype: list\n            """\n            questions = [\n                {\n                    \'type\': \'input\',\n                    \'name\': \'title\',\n                    \'message\': \'Commit title\'\n                },\n                {\n                    \'type\': \'input\',\n                    \'name\': \'issue\',\n                    \'message\': \'Jira Issue number:\'\n                },\n            ]\n            return questions\n\n        def message(self, answers):\n            """Generate the message with the given answers.\n\n            :type answers: dict\n            :rtype: string\n            """\n            return \'{0} (#{1})\'.format(answers[\'title\'], answers[\'issue\'])\n\n        def example(self):\n            """Provide an example to help understand the style (OPTIONAL)\n            Used by cz example.\n\n            :rtype: string\n            """\n            return \'Problem with user (#321)\'\n\n        def schema(self):\n            """Show the schema used (OPTIONAL)\n\n            :rtype: string\n            """\n            return \'<title> (<issue>)\'\n\n        def info(self):\n            """Explanation of the commit rules. (OPTIONAL)\n            :rtype: string\n            """\n            return \'We use this because is useful\'\n\n\n    discover_this = JiraCz  # used by the plugin system\n\n\nThe next file required is :code:`setup.py` modified from flask version\n\n.. code-block:: python\n\n    from distutils.core import setup\n\n    setup(\n        name=\'JiraCommitizen\',\n        version=\'0.1.0\',\n        py_modules=[\'cz_jira\'],\n        license=\'MIT\',\n        long_description=\'this is a long description\',\n        install_requires=[\'commitizen\']\n    )\n\nSo at the end we would have\n\n::\n\n    .\n    ├── cz_jira.py\n    └── setup.py\n\nAnd that\'s it, you can install it without uploading to pypi by simply doing\n:code:`pip install .` If you feel like it should be part of the repo, create a\nPR.\n\nPython 2 support\n=================\n\nThere\'s no longer support for python 2. Nor planned suppport.\n\nFeel free to create a PR.\n\nContributing\n============\n\n\n1. Clone the repo.\n2. Add your modifications\n3. Run :code:`python setup.py test --pytest-args --cov=./commitizen`\n\n\nTesting\n========\n\n    pytest -s --cov-report term-missing --cov=commitizen tests/\n',
    'author': 'Santiago Fraire',
    'author_email': 'santiwilly@gmail.com',
    'url': 'https://github.com/woile/commitizen',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>3.6',
}


setup(**setup_kwargs)
