# commitmessagegenerator

Generate objective and technical commit messages with AI (Google Gemini) automatically using your `git diff`.

## 📦 Install

```bash
pip install commitmessagegenerator
```

Or, if you're using a `venv`:

```bash
python -m venv venv
source venv/bin/activate  # or .\venv\Scripts\activate in Windows
pip install commitmessagegenerator
```

## ⚙️ Configuring

```bash
commitgen -cf
```

This will prompt you for:

1. Your Gemini API key
2. Your preferred AI model (with options to choose from)

## Run this and type you API key to the terminal so the package creates the .env file and automatically adds it to the .gitignore

Or do it manually:

## IMPORTANT - BEFORE CREATING THIS FILE ADD '.venv' TO YOUR .gitignore SO YOUR API KEY ISN'T EXPOSED

Create a `.env` file in the directory where you will run commitgen (usually the root of your Git project):

```
GEMINI_API_KEY=your-gemini-api-key
AI_MODEL=gemini-2.0-flash
```

## 🚀 Usage

With the terminal, inside any Git repository with pending changes, run:

```bash
commitgen (-c/-cp)
```

The command will:

- Read the git diff;
- Send it to the Google Gemini API using your configured model;
- Return a commit message suggestion directly in your terminal.

### Available Commands

- `commitgen` - Generate commit message only
- `commitgen -c` - Generate and commit with the message
- `commitgen -cp` - Generate, commit, and push
- `commitgen -cf` - Configure API key and model
- `commitgen -s` - Show current configuration status

### Available Models

When configuring with `-cf`, you can choose from:

1. **gemini-2.0-flash** (default) - Fast and efficient
2. **gemini-1.5-flash** - Good balance of speed and quality
3. **gemini-1.5-pro** - Highest quality, slower
4. **gemini-2.0-flash-exp** - Experimental version
5. **gemini-2.5-flash** - Latest version, fast and efficient
6. **gemini-2.5-pro** - Latest version, highest quality

## 🧩 Requisites

- Python 3.8 or higher
- Gemini API Key (Google Generative AI, free at: https://aistudio.google.com/app/apikey)
- Initialized Git repository
- Python dependencies (Automatically installed with the package):
  - `GitPython`
  - `google-generativeai`
  - `python-dotenv`

## 📄 License

```
MIT License
```
