import os

def api_key(key, model="gemini-2.0-flash"):
    if os.path.exists(".env"):
        with open(".env", "r+") as outfile:
            lines = outfile.readlines()
            gemini_api_key = next((line for line in lines if line.startswith("GEMINI_API_KEY=")), None)
            model_line = next((line for line in lines if line.startswith("AI_MODEL=")), None)
            
            outfile.seek(0)
            outfile.truncate()
            
            # Update or add GEMINI_API_KEY
            if gemini_api_key:
                outfile.writelines([line if not line.startswith("GEMINI_API_KEY=") else f"GEMINI_API_KEY={key}\n" for line in lines])
            else:
                outfile.writelines(lines)
                outfile.write(f"GEMINI_API_KEY={key}\n")
            
            # Update or add AI_MODEL
            if model_line:
                outfile.seek(0)
                outfile.truncate()
                outfile.writelines([line if not line.startswith("AI_MODEL=") else f"AI_MODEL={model}\n" for line in outfile.readlines()])
            else:
                outfile.write(f"AI_MODEL={model}\n")
    else:
        with open(".env", "w") as outfile:
            outfile.write(f"GEMINI_API_KEY={key}\n")
            outfile.write(f"AI_MODEL={model}\n")

    if os.path.exists(".gitignore"):
        with open(".gitignore", "r+") as outfile:
            lines = outfile.readlines()
            env_in_gitignore = next((line for line in lines if line.strip() == ".env"), None)
            if not env_in_gitignore:
                outfile.write("\n.env")

def get_configured_model():
    """Get the currently configured AI model from .env file"""
    if os.path.exists(".env"):
        with open(".env", "r") as outfile:
            lines = outfile.readlines()
            model_line = next((line for line in lines if line.startswith("AI_MODEL=")), None)
            if model_line:
                return model_line.split("=", 1)[1].strip()
    return "gemini-2.0-flash"  # Default fallback
