import mssql_python


class Sql:
    def __init__(self, servidor, database, user, passw, autocommit=True, as_dict=True):
        self.nombre = 'Server=' + servidor
        self.nombre = self.nombre + ';Database=' + database
        self.nombre = self.nombre + ';UID=' + user
        self.nombre = self.nombre + ';PWD=' + passw
        self.nombre = self.nombre + ';Encrypt=yes'
        self.nombre = self.nombre + ';TrustServerCertificate=yes'
        self.conexion = mssql_python.connect(self.nombre, autocommit=autocommit)
        self.cursor = self.conexion.cursor()
        self.as_dict = as_dict
        self.autocommit = autocommit

    def cerrar_conexion(self):
        self.conexion.close()

    def ejecutar(self, texto, *parametros):
        try:
            if len(parametros):
                if type(parametros[0]) == tuple:
                    parametros = parametros[0]
            self.cursor.execute(texto,parametros)
            if self.autocommit:
                self.conexion.commit()
        except Exception as e:
            print(texto)
            print(parametros)
            print(e)
            raise Exception(e)

    def ejecutar_varios(self, texto, data: list):
        """Inserciones masivas en la bd

        data = [(1, 2, 3), (4, 5, 6), (7, 8, 9)]
        conn.ejecutar_varios("INSERT INTO [dbo].[T_TRINIDAD_XLS_VENTA_MENSUAL] VALUES (%s, %s, %s)", data)

        """
        try:
            self.cursor.executemany(texto, data)
            if self.autocommit:
                self.conexion.commit()
        except Exception as e:
            print(texto)
            print(e)
            raise Exception(e)

    def consultar(self, consulta, as_dict: bool = None):
        self.cursor.execute(consulta)
        if (as_dict is None and self.as_dict) or as_dict:
            columns = [column[0] for column in self.cursor.description]
            return [dict(zip(columns, row)) for row in self.cursor.fetchall()]
        else:
            return self.cursor.fetchall()

