from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from conductor.client.http.api_client import ApiClient


class QueueAdminResourceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def names(self, **kwargs):  # noqa: E501
        """Get Queue Names  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.names(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.names_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.names_with_http_info(**kwargs)  # noqa: E501
            return data

    def names_with_http_info(self, **kwargs):  # noqa: E501
        """Get Queue Names  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.names_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method names" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/queue/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def size1(self, **kwargs):  # noqa: E501
        """Get the queue length  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.size1(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: dict(str, int)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.size1_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.size1_with_http_info(**kwargs)  # noqa: E501
            return data

    def size1_with_http_info(self, **kwargs):  # noqa: E501
        """Get the queue length  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.size1_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: dict(str, int)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method size1" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/queue/size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, int)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update1(self, body, workflow_id, task_ref_name, status, **kwargs):  # noqa: E501
        """Publish a message in queue to mark a wait task as completed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update1(body, workflow_id, task_ref_name, status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :param str workflow_id: (required)
        :param str task_ref_name: (required)
        :param str status: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update1_with_http_info(body, workflow_id, task_ref_name, status, **kwargs)  # noqa: E501
        else:
            (data) = self.update1_with_http_info(body, workflow_id, task_ref_name, status, **kwargs)  # noqa: E501
            return data

    def update1_with_http_info(self, body, workflow_id, task_ref_name, status, **kwargs):  # noqa: E501
        """Publish a message in queue to mark a wait task as completed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update1_with_http_info(body, workflow_id, task_ref_name, status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :param str workflow_id: (required)
        :param str task_ref_name: (required)
        :param str status: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'workflow_id', 'task_ref_name', 'status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update1`")  # noqa: E501
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params or
                params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `update1`")  # noqa: E501
        # verify the required parameter 'task_ref_name' is set
        if ('task_ref_name' not in params or
                params['task_ref_name'] is None):
            raise ValueError("Missing the required parameter `task_ref_name` when calling `update1`")  # noqa: E501
        # verify the required parameter 'status' is set
        if ('status' not in params or
                params['status'] is None):
            raise ValueError("Missing the required parameter `status` when calling `update1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501
        if 'task_ref_name' in params:
            path_params['taskRefName'] = params['task_ref_name']  # noqa: E501
        if 'status' in params:
            path_params['status'] = params['status']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/queue/update/{workflowId}/{taskRefName}/{status}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_by_task_id(self, body, workflow_id, task_id, status, **kwargs):  # noqa: E501
        """Publish a message in queue to mark a wait task (by taskId) as completed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_by_task_id(body, workflow_id, task_id, status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :param str workflow_id: (required)
        :param str task_id: (required)
        :param str status: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_by_task_id_with_http_info(body, workflow_id, task_id, status, **kwargs)  # noqa: E501
        else:
            (data) = self.update_by_task_id_with_http_info(body, workflow_id, task_id, status, **kwargs)  # noqa: E501
            return data

    def update_by_task_id_with_http_info(self, body, workflow_id, task_id, status, **kwargs):  # noqa: E501
        """Publish a message in queue to mark a wait task (by taskId) as completed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_by_task_id_with_http_info(body, workflow_id, task_id, status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :param str workflow_id: (required)
        :param str task_id: (required)
        :param str status: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'workflow_id', 'task_id', 'status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_by_task_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_by_task_id`")  # noqa: E501
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params or
                params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `update_by_task_id`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `update_by_task_id`")  # noqa: E501
        # verify the required parameter 'status' is set
        if ('status' not in params or
                params['status'] is None):
            raise ValueError("Missing the required parameter `status` when calling `update_by_task_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501
        if 'status' in params:
            path_params['status'] = params['status']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/queue/update/{workflowId}/task/{taskId}/{status}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
