# coding: utf-8

"""
    OpenAPI definition

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from conductor.client.http.api_client import ApiClient


class TaskResourceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def all(self, **kwargs):  # noqa: E501
        """Get the details about each queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: dict(str, int)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.all_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.all_with_http_info(**kwargs)  # noqa: E501
            return data

    def all_with_http_info(self, **kwargs):  # noqa: E501
        """Get the details about each queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: dict(str, int)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/queue/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, int)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def all_verbose(self, **kwargs):  # noqa: E501
        """Get the details about each queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_verbose(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: dict(str, dict(str, dict(str, int)))
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.all_verbose_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.all_verbose_with_http_info(**kwargs)  # noqa: E501
            return data

    def all_verbose_with_http_info(self, **kwargs):  # noqa: E501
        """Get the details about each queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_verbose_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: dict(str, dict(str, dict(str, int)))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_verbose" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/queue/all/verbose', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, dict(str, dict(str, int)))',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_poll(self, tasktype, **kwargs):  # noqa: E501
        """Batch poll for a task of a certain type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_poll(tasktype, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tasktype: (required)
        :param str workerid:
        :param str domain:
        :param int count:
        :param int timeout:
        :return: list[Task]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.batch_poll_with_http_info(tasktype, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_poll_with_http_info(tasktype, **kwargs)  # noqa: E501
            return data

    def batch_poll_with_http_info(self, tasktype, **kwargs):  # noqa: E501
        """Batch poll for a task of a certain type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_poll_with_http_info(tasktype, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tasktype: (required)
        :param str workerid:
        :param str domain:
        :param int count:
        :param int timeout:
        :return: list[Task]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tasktype', 'workerid', 'domain', 'count', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_poll" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tasktype' is set
        if ('tasktype' not in params or
                params['tasktype'] is None):
            raise ValueError("Missing the required parameter `tasktype` when calling `batch_poll`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tasktype' in params:
            path_params['tasktype'] = params['tasktype']  # noqa: E501

        query_params = []
        if 'workerid' in params:
            query_params.append(('workerid', params['workerid']))  # noqa: E501
        if 'domain' in params:
            query_params.append(('domain', params['domain']))  # noqa: E501
        if 'count' in params:
            query_params.append(('count', params['count']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/poll/batch/{tasktype}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Task]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_poll_data(self, **kwargs):  # noqa: E501
        """Get the last poll data for all task types  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_poll_data(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[PollData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_poll_data_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_poll_data_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_poll_data_with_http_info(self, **kwargs):  # noqa: E501
        """Get the last poll data for all task types  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_poll_data_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[PollData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_poll_data" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/queue/polldata/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PollData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_external_storage_location1(self, path, operation, payload_type, **kwargs):  # noqa: E501
        """Get the external uri where the task payload is to be stored  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_storage_location1(path, operation, payload_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str operation: (required)
        :param str payload_type: (required)
        :return: ExternalStorageLocation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_external_storage_location1_with_http_info(path, operation, payload_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_external_storage_location1_with_http_info(path, operation, payload_type, **kwargs)  # noqa: E501
            return data

    def get_external_storage_location1_with_http_info(self, path, operation, payload_type, **kwargs):  # noqa: E501
        """Get the external uri where the task payload is to be stored  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_storage_location1_with_http_info(path, operation, payload_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str path: (required)
        :param str operation: (required)
        :param str payload_type: (required)
        :return: ExternalStorageLocation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'operation', 'payload_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_storage_location1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `get_external_storage_location1`")  # noqa: E501
        # verify the required parameter 'operation' is set
        if ('operation' not in params or
                params['operation'] is None):
            raise ValueError("Missing the required parameter `operation` when calling `get_external_storage_location1`")  # noqa: E501
        # verify the required parameter 'payload_type' is set
        if ('payload_type' not in params or
                params['payload_type'] is None):
            raise ValueError("Missing the required parameter `payload_type` when calling `get_external_storage_location1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'operation' in params:
            query_params.append(('operation', params['operation']))  # noqa: E501
        if 'payload_type' in params:
            query_params.append(('payloadType', params['payload_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/externalstoragelocation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExternalStorageLocation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_poll_data(self, task_type, **kwargs):  # noqa: E501
        """Get the last poll data for a given task type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_poll_data(task_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_type: (required)
        :return: list[PollData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_poll_data_with_http_info(task_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_poll_data_with_http_info(task_type, **kwargs)  # noqa: E501
            return data

    def get_poll_data_with_http_info(self, task_type, **kwargs):  # noqa: E501
        """Get the last poll data for a given task type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_poll_data_with_http_info(task_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_type: (required)
        :return: list[PollData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_poll_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_type' is set
        if ('task_type' not in params or
                params['task_type'] is None):
            raise ValueError("Missing the required parameter `task_type` when calling `get_poll_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'task_type' in params:
            query_params.append(('taskType', params['task_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/queue/polldata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PollData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task(self, task_id, **kwargs):  # noqa: E501
        """Get task by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: (required)
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_task_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_task_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_task_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Get task by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: (required)
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/{taskId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Task',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_logs(self, task_id, **kwargs):  # noqa: E501
        """Get Task Execution Logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_logs(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: (required)
        :return: list[TaskExecLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_task_logs_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_task_logs_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_task_logs_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Get Task Execution Logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_logs_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: (required)
        :return: list[TaskExecLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_task_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/{taskId}/log', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TaskExecLog]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def log(self, body, task_id, **kwargs):  # noqa: E501
        """Log Task Execution Details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.log(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str task_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.log_with_http_info(body, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.log_with_http_info(body, task_id, **kwargs)  # noqa: E501
            return data

    def log_with_http_info(self, body, task_id, **kwargs):  # noqa: E501
        """Log Task Execution Details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.log_with_http_info(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str task_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `log`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/{taskId}/log', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def poll(self, tasktype, **kwargs):  # noqa: E501
        """Poll for a task of a certain type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.poll(tasktype, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tasktype: (required)
        :param str workerid:
        :param str domain:
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.poll_with_http_info(tasktype, **kwargs)  # noqa: E501
        else:
            (data) = self.poll_with_http_info(tasktype, **kwargs)  # noqa: E501
            return data

    def poll_with_http_info(self, tasktype, **kwargs):  # noqa: E501
        """Poll for a task of a certain type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.poll_with_http_info(tasktype, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tasktype: (required)
        :param str workerid:
        :param str domain:
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tasktype', 'workerid', 'domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method poll" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tasktype' is set
        if ('tasktype' not in params or
                params['tasktype'] is None):
            raise ValueError("Missing the required parameter `tasktype` when calling `poll`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tasktype' in params:
            path_params['tasktype'] = params['tasktype']  # noqa: E501

        query_params = []
        if 'workerid' in params:
            query_params.append(('workerid', params['workerid']))  # noqa: E501
        if 'domain' in params:
            query_params.append(('domain', params['domain']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/poll/{tasktype}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Task',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def requeue_pending_task(self, task_type, **kwargs):  # noqa: E501
        """Requeue pending tasks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.requeue_pending_task(task_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_type: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.requeue_pending_task_with_http_info(task_type, **kwargs)  # noqa: E501
        else:
            (data) = self.requeue_pending_task_with_http_info(task_type, **kwargs)  # noqa: E501
            return data

    def requeue_pending_task_with_http_info(self, task_type, **kwargs):  # noqa: E501
        """Requeue pending tasks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.requeue_pending_task_with_http_info(task_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_type: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method requeue_pending_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_type' is set
        if ('task_type' not in params or
                params['task_type'] is None):
            raise ValueError("Missing the required parameter `task_type` when calling `requeue_pending_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_type' in params:
            path_params['taskType'] = params['task_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/queue/requeue/{taskType}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search1(self, **kwargs):  # noqa: E501
        """Search for tasks based in payload and other parameters  # noqa: E501

        use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search1(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int start:
        :param int size:
        :param str sort:
        :param str free_text:
        :param str query:
        :return: SearchResultTaskSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search1_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search1_with_http_info(**kwargs)  # noqa: E501
            return data

    def search1_with_http_info(self, **kwargs):  # noqa: E501
        """Search for tasks based in payload and other parameters  # noqa: E501

        use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search1_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int start:
        :param int size:
        :param str sort:
        :param str free_text:
        :param str query:
        :return: SearchResultTaskSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start', 'size', 'sort', 'free_text', 'query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search1" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'free_text' in params:
            query_params.append(('freeText', params['free_text']))  # noqa: E501
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchResultTaskSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_v21(self, **kwargs):  # noqa: E501
        """Search for tasks based in payload and other parameters  # noqa: E501

        use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_v21(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int start:
        :param int size:
        :param str sort:
        :param str free_text:
        :param str query:
        :return: SearchResultTask
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_v21_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_v21_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_v21_with_http_info(self, **kwargs):  # noqa: E501
        """Search for tasks based in payload and other parameters  # noqa: E501

        use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_v21_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int start:
        :param int size:
        :param str sort:
        :param str free_text:
        :param str query:
        :return: SearchResultTask
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start', 'size', 'sort', 'free_text', 'query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_v21" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'free_text' in params:
            query_params.append(('freeText', params['free_text']))  # noqa: E501
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/search-v2', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchResultTask',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def size(self, **kwargs):  # noqa: E501
        """Get Task type queue sizes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.size(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] task_type:
        :return: dict(str, int)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.size_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.size_with_http_info(**kwargs)  # noqa: E501
            return data

    def size_with_http_info(self, **kwargs):  # noqa: E501
        """Get Task type queue sizes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.size_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] task_type:
        :return: dict(str, int)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method size" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'task_type' in params:
            query_params.append(('taskType', params['task_type']))  # noqa: E501
            collection_formats['taskType'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks/queue/sizes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, int)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_task(self, body, **kwargs):  # noqa: E501
        """Update a task  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_task(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaskResult body: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_task_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_task_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def update_task_with_http_info(self, body, **kwargs):  # noqa: E501
        """Update a task  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_task_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaskResult body: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/tasks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
