from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from conductor.client.http.api_client import ApiClient


class IntegrationResourceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def associate_prompt_with_integration(self, integration_provider, integration_name, prompt_name,
                                          **kwargs):  # noqa: E501
        """Associate a Prompt Template with an Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.associate_prompt_with_integration(integration_provider, integration_name, prompt_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str integration_provider: (required)
        :param str integration_name: (required)
        :param str prompt_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.associate_prompt_with_integration_with_http_info(integration_provider, integration_name,
                                                                         prompt_name, **kwargs)  # noqa: E501
        else:
            (data) = self.associate_prompt_with_integration_with_http_info(integration_provider, integration_name,
                                                                           prompt_name, **kwargs)  # noqa: E501
            return data

    def associate_prompt_with_integration_with_http_info(self, integration_provider, integration_name, prompt_name,
                                                         **kwargs):  # noqa: E501
        """Associate a Prompt Template with an Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.associate_prompt_with_integration_with_http_info(integration_provider, integration_name, prompt_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str integration_provider: (required)
        :param str integration_name: (required)
        :param str prompt_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_provider', 'integration_name', 'prompt_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method associate_prompt_with_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_provider' is set
        if ('integration_provider' not in params or
                params['integration_provider'] is None):
            raise ValueError(
                "Missing the required parameter `integration_provider` when calling `associate_prompt_with_integration`")  # noqa: E501
        # verify the required parameter 'integration_name' is set
        if ('integration_name' not in params or
                params['integration_name'] is None):
            raise ValueError(
                "Missing the required parameter `integration_name` when calling `associate_prompt_with_integration`")  # noqa: E501
        # verify the required parameter 'prompt_name' is set
        if ('prompt_name' not in params or
                params['prompt_name'] is None):
            raise ValueError(
                "Missing the required parameter `prompt_name` when calling `associate_prompt_with_integration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'integration_provider' in params:
            path_params['integration_provider'] = params['integration_provider']  # noqa: E501
        if 'integration_name' in params:
            path_params['integration_name'] = params['integration_name']  # noqa: E501
        if 'prompt_name' in params:
            path_params['prompt_name'] = params['prompt_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{integration_provider}/integration/{integration_name}/prompt/{prompt_name}',
            'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_integration_api(self, name, integration_name, **kwargs):  # noqa: E501
        """Delete an Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_integration_api(name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str integration_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_integration_api_with_http_info(name, integration_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_integration_api_with_http_info(name, integration_name, **kwargs)  # noqa: E501
            return data

    def delete_integration_api_with_http_info(self, name, integration_name, **kwargs):  # noqa: E501
        """Delete an Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_integration_api_with_http_info(name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str integration_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'integration_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_integration_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `delete_integration_api`")  # noqa: E501
        # verify the required parameter 'integration_name' is set
        if ('integration_name' not in params or
                params['integration_name'] is None):
            raise ValueError(
                "Missing the required parameter `integration_name` when calling `delete_integration_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'integration_name' in params:
            path_params['integration_name'] = params['integration_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/integration/{integration_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_integration_provider(self, name, **kwargs):  # noqa: E501
        """Delete an Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_integration_provider(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_integration_provider_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_integration_provider_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def delete_integration_provider_with_http_info(self, name, **kwargs):  # noqa: E501
        """Delete an Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_integration_provider_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_integration_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `delete_integration_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tag_for_integration(self, body, name, integration_name, **kwargs):  # noqa: E501
        """Delete a tag for Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tag_for_integration(body, name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[TagObject] body: (required)
        :param str name: (required)
        :param str integration_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tag_for_integration_with_http_info(body, name, integration_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tag_for_integration_with_http_info(body, name, integration_name,
                                                                    **kwargs)  # noqa: E501
            return data

    def delete_tag_for_integration_with_http_info(self, body, name, integration_name, **kwargs):  # noqa: E501
        """Delete a tag for Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tag_for_integration_with_http_info(body, name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[TagObject] body: (required)
        :param str name: (required)
        :param str integration_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name', 'integration_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tag_for_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `delete_tag_for_integration`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `delete_tag_for_integration`")  # noqa: E501
        # verify the required parameter 'integration_name' is set
        if ('integration_name' not in params or
                params['integration_name'] is None):
            raise ValueError(
                "Missing the required parameter `integration_name` when calling `delete_tag_for_integration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'integration_name' in params:
            path_params['integration_name'] = params['integration_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/integration/{integration_name}/tags', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tag_for_integration_provider(self, body, name, **kwargs):  # noqa: E501
        """Delete a tag for Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tag_for_integration_provider(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[TagObject] body: (required)
        :param str name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tag_for_integration_provider_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tag_for_integration_provider_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def delete_tag_for_integration_provider_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """Delete a tag for Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tag_for_integration_provider_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[TagObject] body: (required)
        :param str name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tag_for_integration_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `delete_tag_for_integration_provider`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `delete_tag_for_integration_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/tags', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_integration_api(self, name, integration_name, **kwargs):  # noqa: E501
        """Get Integration details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_api(name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str integration_name: (required)
        :return: IntegrationApi
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_integration_api_with_http_info(name, integration_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_integration_api_with_http_info(name, integration_name, **kwargs)  # noqa: E501
            return data

    def get_integration_api_with_http_info(self, name, integration_name, **kwargs):  # noqa: E501
        """Get Integration details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_api_with_http_info(name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str integration_name: (required)
        :return: IntegrationApi
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'integration_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integration_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_integration_api`")  # noqa: E501
        # verify the required parameter 'integration_name' is set
        if ('integration_name' not in params or
                params['integration_name'] is None):
            raise ValueError(
                "Missing the required parameter `integration_name` when calling `get_integration_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'integration_name' in params:
            path_params['integration_name'] = params['integration_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/integration/{integration_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IntegrationApi',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_integration_apis(self, name, **kwargs):  # noqa: E501
        """Get Integrations of an Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_apis(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param bool active_only:
        :return: list[IntegrationApi]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_integration_apis_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_integration_apis_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_integration_apis_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get Integrations of an Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_apis_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param bool active_only:
        :return: list[IntegrationApi]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'active_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integration_apis" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_integration_apis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'active_only' in params:
            query_params.append(('activeOnly', params['active_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/integration', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IntegrationApi]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_integration_available_apis(self, name, **kwargs):  # noqa: E501
        """Get Integrations Available for an Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_available_apis(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_integration_available_apis_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_integration_available_apis_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_integration_available_apis_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get Integrations Available for an Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_available_apis_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integration_available_apis" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `get_integration_available_apis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/integration/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_integration_provider(self, name, **kwargs):  # noqa: E501
        """Get Integration provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_provider(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: Integration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_integration_provider_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_integration_provider_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_integration_provider_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get Integration provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_provider_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: Integration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integration_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `get_integration_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Integration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_integration_provider_defs(self, **kwargs):  # noqa: E501
        """Get Integration provider definitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_provider_defs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[IntegrationDef]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_integration_provider_defs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_integration_provider_defs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_integration_provider_defs_with_http_info(self, **kwargs):  # noqa: E501
        """Get Integration provider definitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_provider_defs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[IntegrationDef]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integration_provider_defs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/def', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IntegrationDef]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_integration_providers(self, **kwargs):  # noqa: E501
        """Get all Integrations Providers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_providers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type:
        :param bool active_only:
        :return: list[Integration]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_integration_providers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_integration_providers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_integration_providers_with_http_info(self, **kwargs):  # noqa: E501
        """Get all Integrations Providers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_integration_providers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type:
        :param bool active_only:
        :return: list[Integration]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'active_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_integration_providers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'active_only' in params:
            query_params.append(('activeOnly', params['active_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Integration]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_prompts_with_integration(self, integration_provider, integration_name, **kwargs):  # noqa: E501
        """Get the list of prompt templates associated with an integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_prompts_with_integration(integration_provider, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str integration_provider: (required)
        :param str integration_name: (required)
        :return: list[PromptTemplate]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_prompts_with_integration_with_http_info(integration_provider, integration_name,
                                                                    **kwargs)  # noqa: E501
        else:
            (data) = self.get_prompts_with_integration_with_http_info(integration_provider, integration_name,
                                                                      **kwargs)  # noqa: E501
            return data

    def get_prompts_with_integration_with_http_info(self, integration_provider, integration_name,
                                                    **kwargs):  # noqa: E501
        """Get the list of prompt templates associated with an integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_prompts_with_integration_with_http_info(integration_provider, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str integration_provider: (required)
        :param str integration_name: (required)
        :return: list[PromptTemplate]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_provider', 'integration_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_prompts_with_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_provider' is set
        if ('integration_provider' not in params or
                params['integration_provider'] is None):
            raise ValueError(
                "Missing the required parameter `integration_provider` when calling `get_prompts_with_integration`")  # noqa: E501
        # verify the required parameter 'integration_name' is set
        if ('integration_name' not in params or
                params['integration_name'] is None):
            raise ValueError(
                "Missing the required parameter `integration_name` when calling `get_prompts_with_integration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'integration_provider' in params:
            path_params['integration_provider'] = params['integration_provider']  # noqa: E501
        if 'integration_name' in params:
            path_params['integration_name'] = params['integration_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{integration_provider}/integration/{integration_name}/prompt', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PromptTemplate]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_providers_and_integrations(self, **kwargs):  # noqa: E501
        """Get Integrations Providers and Integrations combo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_and_integrations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type:
        :param bool active_only:
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_providers_and_integrations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_providers_and_integrations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_providers_and_integrations_with_http_info(self, **kwargs):  # noqa: E501
        """Get Integrations Providers and Integrations combo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_and_integrations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type:
        :param bool active_only:
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'active_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_providers_and_integrations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'active_only' in params:
            query_params.append(('activeOnly', params['active_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tags_for_integration(self, name, integration_name, **kwargs):  # noqa: E501
        """Get tags by Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tags_for_integration(name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str integration_name: (required)
        :return: list[TagObject]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tags_for_integration_with_http_info(name, integration_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tags_for_integration_with_http_info(name, integration_name, **kwargs)  # noqa: E501
            return data

    def get_tags_for_integration_with_http_info(self, name, integration_name, **kwargs):  # noqa: E501
        """Get tags by Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tags_for_integration_with_http_info(name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str integration_name: (required)
        :return: list[TagObject]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'integration_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tags_for_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `get_tags_for_integration`")  # noqa: E501
        # verify the required parameter 'integration_name' is set
        if ('integration_name' not in params or
                params['integration_name'] is None):
            raise ValueError(
                "Missing the required parameter `integration_name` when calling `get_tags_for_integration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'integration_name' in params:
            path_params['integration_name'] = params['integration_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/integration/{integration_name}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TagObject]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tags_for_integration_provider(self, name, **kwargs):  # noqa: E501
        """Get tags by Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tags_for_integration_provider(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: list[TagObject]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tags_for_integration_provider_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tags_for_integration_provider_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_tags_for_integration_provider_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get tags by Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tags_for_integration_provider_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: list[TagObject]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tags_for_integration_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `get_tags_for_integration_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TagObject]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_token_usage_for_integration(self, name, integration_name, **kwargs):  # noqa: E501
        """Get Token Usage by Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_token_usage_for_integration(name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str integration_name: (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_token_usage_for_integration_with_http_info(name, integration_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_token_usage_for_integration_with_http_info(name, integration_name, **kwargs)  # noqa: E501
            return data

    def get_token_usage_for_integration_with_http_info(self, name, integration_name, **kwargs):  # noqa: E501
        """Get Token Usage by Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_token_usage_for_integration_with_http_info(name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param str integration_name: (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'integration_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_token_usage_for_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `get_token_usage_for_integration`")  # noqa: E501
        # verify the required parameter 'integration_name' is set
        if ('integration_name' not in params or
                params['integration_name'] is None):
            raise ValueError(
                "Missing the required parameter `integration_name` when calling `get_token_usage_for_integration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'integration_name' in params:
            path_params['integration_name'] = params['integration_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/integration/{integration_name}/metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_token_usage_for_integration_provider(self, name, **kwargs):  # noqa: E501
        """Get Token Usage by Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_token_usage_for_integration_provider(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_token_usage_for_integration_provider_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_token_usage_for_integration_provider_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_token_usage_for_integration_provider_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get Token Usage by Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_token_usage_for_integration_provider_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_token_usage_for_integration_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `get_token_usage_for_integration_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_tag_for_integration(self, body, name, integration_name, **kwargs):  # noqa: E501
        """Put a tag to Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_tag_for_integration(body, name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[TagObject] body: (required)
        :param str name: (required)
        :param str integration_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_tag_for_integration_with_http_info(body, name, integration_name, **kwargs)  # noqa: E501
        else:
            (data) = self.put_tag_for_integration_with_http_info(body, name, integration_name, **kwargs)  # noqa: E501
            return data

    def put_tag_for_integration_with_http_info(self, body, name, integration_name, **kwargs):  # noqa: E501
        """Put a tag to Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_tag_for_integration_with_http_info(body, name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[TagObject] body: (required)
        :param str name: (required)
        :param str integration_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name', 'integration_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_tag_for_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `put_tag_for_integration`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `put_tag_for_integration`")  # noqa: E501
        # verify the required parameter 'integration_name' is set
        if ('integration_name' not in params or
                params['integration_name'] is None):
            raise ValueError(
                "Missing the required parameter `integration_name` when calling `put_tag_for_integration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'integration_name' in params:
            path_params['integration_name'] = params['integration_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/integration/{integration_name}/tags', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_tag_for_integration_provider(self, body, name, **kwargs):  # noqa: E501
        """Put a tag to Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_tag_for_integration_provider(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[TagObject] body: (required)
        :param str name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_tag_for_integration_provider_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.put_tag_for_integration_provider_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def put_tag_for_integration_provider_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """Put a tag to Integration Provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_tag_for_integration_provider_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[TagObject] body: (required)
        :param str name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_tag_for_integration_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `put_tag_for_integration_provider`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `put_tag_for_integration_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/tags', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_token_usage(self, body, name, integration_name, **kwargs):  # noqa: E501
        """Register Token usage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_token_usage(body, name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int body: (required)
        :param str name: (required)
        :param str integration_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_token_usage_with_http_info(body, name, integration_name, **kwargs)  # noqa: E501
        else:
            (data) = self.register_token_usage_with_http_info(body, name, integration_name, **kwargs)  # noqa: E501
            return data

    def register_token_usage_with_http_info(self, body, name, integration_name, **kwargs):  # noqa: E501
        """Register Token usage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_token_usage_with_http_info(body, name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int body: (required)
        :param str name: (required)
        :param str integration_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name', 'integration_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_token_usage" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `register_token_usage`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `register_token_usage`")  # noqa: E501
        # verify the required parameter 'integration_name' is set
        if ('integration_name' not in params or
                params['integration_name'] is None):
            raise ValueError(
                "Missing the required parameter `integration_name` when calling `register_token_usage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'integration_name' in params:
            path_params['integration_name'] = params['integration_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/integration/{integration_name}/metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_integration_api(self, body, name, integration_name, **kwargs):  # noqa: E501
        """Create or Update Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_integration_api(body, name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IntegrationApiUpdate body: (required)
        :param str name: (required)
        :param str integration_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_integration_api_with_http_info(body, name, integration_name, **kwargs)  # noqa: E501
        else:
            (data) = self.save_integration_api_with_http_info(body, name, integration_name, **kwargs)  # noqa: E501
            return data

    def save_integration_api_with_http_info(self, body, name, integration_name, **kwargs):  # noqa: E501
        """Create or Update Integration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_integration_api_with_http_info(body, name, integration_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IntegrationApiUpdate body: (required)
        :param str name: (required)
        :param str integration_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name', 'integration_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_integration_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `save_integration_api`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `save_integration_api`")  # noqa: E501
        # verify the required parameter 'integration_name' is set
        if ('integration_name' not in params or
                params['integration_name'] is None):
            raise ValueError(
                "Missing the required parameter `integration_name` when calling `save_integration_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'integration_name' in params:
            path_params['integration_name'] = params['integration_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}/integration/{integration_name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_integration_provider(self, body, name, **kwargs):  # noqa: E501
        """Create or Update Integration provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_integration_provider(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IntegrationUpdate body: (required)
        :param str name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_integration_provider_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.save_integration_provider_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def save_integration_provider_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """Create or Update Integration provider  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_integration_provider_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IntegrationUpdate body: (required)
        :param str name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_integration_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `save_integration_provider`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `save_integration_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/integrations/provider/{name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
